package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Uint16;

/**
 * LCCF响应VASS文件构建类
 *
 * @author wzs
 * @version v1.0
 * @ClassName LCCFDownLoadBuilder
 * @Date 2019/12/24 11:19
 */
public class LCCFDownLoadBuilder {
    public static final int SUCCESS = 200;
    public static final int ERROR = 500;
    public static final int NO_NEW = 304;

    /**
     * 响应新文件
     *
     * @param bytes
     * @return
     * @throws Exception
     */
    public static LCCFDownLoad buildSuccess(byte[] bytes) throws Exception {
        LCCFDownLoad lccfDownLoad = new LCCFDownLoad();
        Uint16 uint16 = new Uint16(SUCCESS);
        lccfDownLoad.setCode(uint16);
        LocalCertificateChainFile localCertificateChainFile = LocalCertificateChainFileHolder.build(bytes);
        lccfDownLoad.setFileContent(localCertificateChainFile);
        return lccfDownLoad;
    }

    /**
     * 响应错误信息，无文件内容
     *
     * @return
     * @throws Exception
     */
    public static LCCFDownLoad buildError() throws Exception {
        LCCFDownLoad lccfDownLoad = new LCCFDownLoad();
        Uint16 uint16 = new Uint16(ERROR);
        lccfDownLoad.setCode(uint16);
        return lccfDownLoad;
    }

    /**
     * 响应无文件信息，无文件内容
     *
     * @return
     * @throws Exception
     */
    public static LCCFDownLoad buildNoNew() throws Exception {
        LCCFDownLoad lccfDownLoad = new LCCFDownLoad();
        Uint16 uint16 = new Uint16(NO_NEW);
        lccfDownLoad.setCode(uint16);
        return lccfDownLoad;
    }
}