package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Sequence;

import java.util.Vector;

/**
 * LCCF结构体定义
 * LocalCertificateChainFile ::= SEQUENCE {
 * version CompositeVersion,
 * requiredCertStore CertificateStore --RCA、PG、CRLG、ICA、ECA、PCA
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName LocalCertificateChainFile
 * @Date 2019/12/24 11:19
 */
public class LocalCertificateChainFile extends Sequence {
    private CompositeVersion version;
    private CertificateStore requiredCerStore;

    public LocalCertificateChainFile(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LocalCertificateChainFile() {
        super(false, false);
    }

    public CompositeVersion getVersion() {
        return version;
    }

    public void setVersion(CompositeVersion version) {
        this.version = version;
    }

    public CertificateStore getRequiredCerStore() {
        return requiredCerStore;
    }

    public void setRequiredCerStore(CertificateStore requiredCerStore) {
        this.requiredCerStore = requiredCerStore;
    }

    public static LocalCertificateChainFile getInstance(byte[] data) throws Exception {
        LocalCertificateChainFile localCertificateChainFile = new LocalCertificateChainFile();
        CompositeVersion compositeVersion = CompositeVersion.getInstance(data);
        CertificateStore certificateStore = CertificateStore.getInstance(compositeVersion.getGoal());
        localCertificateChainFile.setVersion(compositeVersion);
        localCertificateChainFile.setRequiredCerStore(certificateStore);
        localCertificateChainFile.setGoal(certificateStore.getGoal());
        return localCertificateChainFile;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(version);
        vector.add(requiredCerStore);
        return vector;
    }
}
