package com.xdja.pki.oer.batc.lccf;

import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.gbt.asn1.SequenceOfCertificate;

/**
 * LCCF文件构建类
 *
 * @author wzs
 * @version v1.0
 * @ClassName LocalCertificateChainFileBuilder
 * @Date 2019/12/24 11:19
 */
public class LocalCertificateChainFileBuilder {
    /**
     * 构建LCCF
     *
     * @param gccfVersion
     * @param lccfVersion
     * @param certs
     * @return
     * @throws Exception
     */
    public static LocalCertificateChainFile build(int gccfVersion, int lccfVersion, SequenceOfCertificate certs) throws Exception {
        CompositeVersion compositeVersion = new CompositeVersion();
        Uint16 gccfVersionUint16 = new Uint16(gccfVersion);
        Uint16 lccfVersionUint16 = new Uint16(lccfVersion);
        compositeVersion.setGccfVersion(gccfVersionUint16);
        compositeVersion.setLccfVersion(lccfVersionUint16);
        CertificateStore certificateStore = new CertificateStore();
        certificateStore.setCerts(certs);
        LocalCertificateChainFile lccf = new LocalCertificateChainFile();
        lccf.setVersion(compositeVersion);
        lccf.setRequiredCerStore(certificateStore);
        return lccf;
    }

    /**
     * 构建LCCF
     * @param gccfVersionUint16
     * @param lccfVersionUint16
     * @param certs
     * @return
     * @throws Exception
     */
    public static LocalCertificateChainFile build(Uint16 gccfVersionUint16, Uint16 lccfVersionUint16, SequenceOfCertificate certs) throws Exception {
        CompositeVersion compositeVersion = new CompositeVersion();
        compositeVersion.setGccfVersion(gccfVersionUint16);
        compositeVersion.setLccfVersion(lccfVersionUint16);
        CertificateStore certificateStore = new CertificateStore();
        certificateStore.setCerts(certs);
        LocalCertificateChainFile lccf = new LocalCertificateChainFile();
        lccf.setVersion(compositeVersion);
        lccf.setRequiredCerStore(certificateStore);
        return lccf;
    }
}
