package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;

import java.util.Vector;

/**
 * 自定义策略项结构体定义
 * CustomPolicyData ::= SEQUENCE {
 * hostostname OCTET STRING (SIZE (0..32)),
 * globalPolicy GlobalPolicyData,
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName CustomPolicyData
 * @Date 2019/12/24 11:19
 */
public class CustomPolicyData extends Sequence {
    private OctetString hostname;
    private GlobalPolicyData globalPolicy;

    public CustomPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public CustomPolicyData() {
        super(false, false);
    }

    public OctetString getHostname() {
        return hostname;
    }

    public void setHostname(OctetString hostname) {
        this.hostname = hostname;
    }

    public GlobalPolicyData getGlobalPolicy() {
        return globalPolicy;
    }

    public void setGlobalPolicy(GlobalPolicyData globalPolicy) {
        this.globalPolicy = globalPolicy;
    }

    public static CustomPolicyData getInstance(byte[] data) throws Exception {
        CustomPolicyData customPolicyData = new CustomPolicyData();
        OctetString hostname = OctetString.getInstance(data);
        customPolicyData.setHostname(hostname);
        GlobalPolicyData globalPolicyData = GlobalPolicyData.getInstance(hostname.getGoal());
        customPolicyData.setGlobalPolicy(globalPolicyData);
        customPolicyData.setGoal(globalPolicyData.getGoal());
        return customPolicyData;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(hostname);
        vector.add(globalPolicy);
        return vector;
    }
}
