package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import com.xdja.pki.oer.base.Uint8;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * 全局策略项结构体定义
 * GlobalPolicyData ::= SEQUENCE {
 * itscaVersion Uint8 DEFAULT 1, -- ITSCA系统的版本，目前只定义VASS暂不使用，默认是1。
 * gpfVersion OCTET STRING (SIZE (32)), --GPF文件全局版本号
 * ecPeriod Duration DEFAULT 1, -- 注册证书的有效期，默认为1年。
 * ecApplyEarlierTime Duration DEFAULT 6, -- 注册证书提前申请时间，默认6个月
 * pcIPeriod Duration DEFAULT 7,-- 假名证书的有效期i值，默认为7天。
 * pcApplyEarlierTime Duration DEFAULT 2, -- 假名证书提前申请时间，默认2天
 * pcOverlapTime Duration DEFAULT 1, -- 假名证书有效重叠时间，默认1小时
 * pcMinCertsPerIPeriod Uint8 DEFAULT 20,-- 假名证书申请一个批次最少的证书数量j值，默认20。
 * pcUseSwitchTime Duration DEFAULT 5, -- 假名证书应用切换时间，默认5，单位默认为分钟，表示5分钟切换一次。
 * pcUseSwitchAlgorithm Uint8 DEFAULT 1,-- 假名证书应用给切换算法，默认1，表示循环切换round-robin，以后支持更多算法需VASS与ITSCA系统行约定。
 * pcMinValidNumber Uint8 DEFAULT 10-- 假名证书最少有效数量，默认为10，表示VASS在少于10张可用假名证书需要进行假名证书申请
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName GlobalPolicyData
 * @Date 2019/12/24 11:19
 */
public class GlobalPolicyData extends Sequence {
    private Uint8 itscaVersion;
    private Uint16 gpfVersion;
    private Duration ecPeriod;
    private Duration ecApplyEarlierTime;
    private Duration pcIPeriod;
    private Duration pcApplyEarlierTime;
    private Duration pcOverlapTime;
    private Uint8 pcMinCertsPerIPeriod;
    private Duration pcUseSwitchTime;
    private Uint8 pcUseSwitchAlgorithm;

    public GlobalPolicyData() {
        super(false, false);
    }

    public GlobalPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public Uint8 getItscaVersion() {
        return itscaVersion;
    }

    public void setItscaVersion(Uint8 itscaVersion) {
        this.itscaVersion = itscaVersion;
    }

    public Duration getEcPeriod() {
        return ecPeriod;
    }

    public void setEcPeriod(Duration ecPeriod) {
        this.ecPeriod = ecPeriod;
    }

    public Duration getEcApplyEarlierTime() {
        return ecApplyEarlierTime;
    }

    public void setEcApplyEarlierTime(Duration ecApplyEarlierTime) {
        this.ecApplyEarlierTime = ecApplyEarlierTime;
    }

    public Duration getPcIPeriod() {
        return pcIPeriod;
    }

    public void setPcIPeriod(Duration pcIPeriod) {
        this.pcIPeriod = pcIPeriod;
    }

    public Duration getPcApplyEarlierTime() {
        return pcApplyEarlierTime;
    }

    public void setPcApplyEarlierTime(Duration pcApplyEarlierTime) {
        this.pcApplyEarlierTime = pcApplyEarlierTime;
    }

    public Duration getPcOverlapTime() {
        return pcOverlapTime;
    }

    public void setPcOverlapTime(Duration pcOverlapTime) {
        this.pcOverlapTime = pcOverlapTime;
    }

    public Uint8 getPcMinCertsPerIPeriod() {
        return pcMinCertsPerIPeriod;
    }

    public void setPcMinCertsPerIPeriod(Uint8 pcMinCertsPerIPeriod) {
        this.pcMinCertsPerIPeriod = pcMinCertsPerIPeriod;
    }

    public Duration getPcUseSwitchTime() {
        return pcUseSwitchTime;
    }

    public void setPcUseSwitchTime(Duration pcUseSwitchTime) {
        this.pcUseSwitchTime = pcUseSwitchTime;
    }

    public Uint8 getPcUseSwitchAlgorithm() {
        return pcUseSwitchAlgorithm;
    }

    public void setPcUseSwitchAlgorithm(Uint8 pcUseSwitchAlgorithm) {
        this.pcUseSwitchAlgorithm = pcUseSwitchAlgorithm;
    }

    public Uint16 getGpfVersion() {
        return gpfVersion;
    }

    public void setGpfVersion(Uint16 gpfVersion) {
        this.gpfVersion = gpfVersion;
    }

    public static GlobalPolicyData getInstance(byte[] data) throws Exception {
        GlobalPolicyData globalPolicyData = new GlobalPolicyData();
        byte[] itscaVersionBytes = new byte[1];
        System.arraycopy(data, 0, itscaVersionBytes, 0, itscaVersionBytes.length);
        globalPolicyData.setItscaVersion(new Uint8(BigIntegers.fromUnsignedByteArray(itscaVersionBytes).intValue()));
        byte[] gpfVersionBytes = new byte[2];
        System.arraycopy(data, 1, gpfVersionBytes, 0, gpfVersionBytes.length);
        globalPolicyData.setGpfVersion(new Uint16(BigIntegers.fromUnsignedByteArray(gpfVersionBytes).intValue()));
        byte[] goal = new byte[data.length - 3];
        System.arraycopy(data, 3, goal, 0, goal.length);
        Duration ecPeriod = Duration.getInstance(goal);
        globalPolicyData.setEcPeriod(ecPeriod);
        Duration ecApplyEarlierTime = Duration.getInstance(ecPeriod.getGoal());
        globalPolicyData.setEcApplyEarlierTime(ecApplyEarlierTime);
        Duration pcIPeriod = Duration.getInstance(ecApplyEarlierTime.getGoal());
        globalPolicyData.setPcIPeriod(pcIPeriod);
        Duration pcApplyEarlierTime = Duration.getInstance(pcIPeriod.getGoal());
        globalPolicyData.setPcApplyEarlierTime(pcApplyEarlierTime);
        Duration pcOverlapTime = Duration.getInstance(pcApplyEarlierTime.getGoal());
        globalPolicyData.setPcOverlapTime(pcOverlapTime);
        byte[] pcMinCertsPerIPeriodBytes = new byte[1];
        System.arraycopy(pcOverlapTime.getGoal(), 0, pcMinCertsPerIPeriodBytes, 0, pcMinCertsPerIPeriodBytes.length);
        globalPolicyData.setPcMinCertsPerIPeriod(new Uint8(BigIntegers.fromUnsignedByteArray(pcMinCertsPerIPeriodBytes).intValue()));
        Duration pcUseSwitchTime = Duration.getInstance(getGoal(pcOverlapTime.getGoal(), 1));
        globalPolicyData.setPcUseSwitchTime(pcUseSwitchTime);
        byte[] pcUseSwitchAlgorithmBytes = new byte[1];
        System.arraycopy(pcUseSwitchTime.getGoal(), 0, pcUseSwitchAlgorithmBytes, 0, pcUseSwitchAlgorithmBytes.length);
        globalPolicyData.setPcUseSwitchAlgorithm(new Uint8(BigIntegers.fromUnsignedByteArray(pcUseSwitchAlgorithmBytes).intValue()));
        globalPolicyData.setGoal(getGoal(pcUseSwitchTime.getGoal(), 1));
        return globalPolicyData;
    }

    /**
     * 获得goal
     *
     * @param data    总字节数
     * @param byteNum 已解析字节数
     * @return
     */
    public static byte[] getGoal(byte[] data, int byteNum) {
        byte[] goal = new byte[data.length - byteNum];
        System.arraycopy(data, byteNum, goal, 0, goal.length);
        return goal;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(itscaVersion);
        vector.add(gpfVersion);
        vector.add(ecPeriod);
        vector.add(ecApplyEarlierTime);
        vector.add(pcIPeriod);
        vector.add(pcApplyEarlierTime);
        vector.add(pcOverlapTime);
        vector.add(pcMinCertsPerIPeriod);
        vector.add(pcUseSwitchTime);
        vector.add(pcUseSwitchAlgorithm);
        return vector;
    }
}
