package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * LPF响应结构体定义
 * LpfFile ::= SEQUENCE {
 * code Uint16,--错误码。200：返回新文件，304：无文件返回，-1：异常
 * fileContent LocalPolicyFile
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName LPFDownLoad
 * @Date 2019/12/24 11:19
 */
public class LPFDownLoad extends Sequence {
    private Uint16 code;
    private LocalPolicyFile fileContent;

    public LPFDownLoad(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LPFDownLoad() {
        super(false, false);
    }

    public static LPFDownLoad getInstance(byte[] data) throws Exception {
        LPFDownLoad lpfDownLoad = new LPFDownLoad();
        byte[] codeBytes = new byte[2];
        System.arraycopy(data, 0, codeBytes, 0, codeBytes.length);
        lpfDownLoad.setCode(new Uint16(BigIntegers.fromUnsignedByteArray(codeBytes).intValue()));
        byte[] goal = new byte[data.length - codeBytes.length];
        if (goal.length > 0) {
            System.arraycopy(data, 2, goal, 0, goal.length);
            LocalPolicyFile localPolicyFile = LocalPolicyFile.getInstance(goal);
            lpfDownLoad.setFileContent(localPolicyFile);
            lpfDownLoad.setGoal(localPolicyFile.getGoal());
        }
        return lpfDownLoad;
    }

    public Uint16 getCode() {
        return code;
    }

    public void setCode(Uint16 code) {
        this.code = code;
    }

    public LocalPolicyFile getFileContent() {
        return fileContent;
    }

    public void setFileContent(LocalPolicyFile fileContent) {
        this.fileContent = fileContent;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(code);
        vector.add(fileContent);
        return vector;
    }
}
