package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Uint16;

/**
 * LPF响应VASS文件构建类
 *
 * @author wzs
 * @version v1.0
 * @ClassName LPFDownLoadBuilder
 * @Date 2019/12/24 11:19
 */
public class LPFDownLoadBuilder {
    public static final int SUCCESS = 200;
    public static final int ERROR = 500;
    public static final int NO_NEW = 304;

    /**
     * 响应新文件
     *
     * @param bytes
     * @return
     * @throws Exception
     */
    public static LPFDownLoad buildSuccess(byte[] bytes) throws Exception {
        LPFDownLoad lpfDownLoad = new LPFDownLoad();
        Uint16 uint16 = new Uint16(SUCCESS);
        lpfDownLoad.setCode(uint16);
        LocalPolicyFile localPolicyFile = LocalPolicyFileHolder.build(bytes);
        lpfDownLoad.setFileContent(localPolicyFile);
        return lpfDownLoad;
    }

    /**
     * 响应错误信息，无文件内容
     *
     * @return
     * @throws Exception
     */
    public static LPFDownLoad buildError() throws Exception {
        LPFDownLoad lpfDownLoad = new LPFDownLoad();
        Uint16 uint16 = new Uint16(ERROR);
        lpfDownLoad.setCode(uint16);
        return lpfDownLoad;
    }

    /**
     * 响应无文件信息，无文件内容
     *
     * @return
     * @throws Exception
     */
    public static LPFDownLoad buildNoNew() throws Exception {
        LPFDownLoad lpfDownLoad = new LPFDownLoad();
        Uint16 uint16 = new Uint16(NO_NEW);
        lpfDownLoad.setCode(uint16);
        return lpfDownLoad;
    }
}