package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.base.Uint16;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * 本地策略项结构体定义
 * LocalPolicyData ::= SEQUENCE {
 * lpfVersion Uint16, --LPF文件本地版本号
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName LocalPolicyData
 * @Date 2019/12/24 11:19
 */
public class LocalPolicyData extends Sequence {
    private Uint16 lpfVersion;

    public LocalPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LocalPolicyData() {
        super(false, false);
    }

    public Uint16 getLpfVersion() {
        return lpfVersion;
    }

    public void setLpfVersion(Uint16 lpfVersion) {
        this.lpfVersion = lpfVersion;
    }

    public static LocalPolicyData getInstance(byte[] data) throws Exception {
        LocalPolicyData localPolicyData = new LocalPolicyData();
        byte[] lpfVersionBytes = new byte[2];
        System.arraycopy(data, 0, lpfVersionBytes, 0, lpfVersionBytes.length);
        localPolicyData.setLpfVersion(new Uint16(BigIntegers.fromUnsignedByteArray(lpfVersionBytes).intValue()));
        byte[] goal = new byte[data.length - lpfVersionBytes.length];
        System.arraycopy(data, 2, goal, 0, goal.length);
        localPolicyData.setGoal(goal);
        return localPolicyData;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(lpfVersion);
        return vector;
    }
}
