package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.SecuredMessage;

import java.util.Vector;

/**
 * LPF文件结构体定义
 * LocalPolicyFile ::= SEQUENCE {
 * globalParameters SecuredMessage,
 * localParamters SecuredMessage
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName LocalPolicyFile
 * @Date 2019/12/24 11:19
 */
public class LocalPolicyFile extends Sequence {
    private SecuredMessage globalParameters;
    private SecuredMessage localParameters;

    public LocalPolicyFile(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public LocalPolicyFile() {
        super(false, false);
    }

    public SecuredMessage getGlobalParameters() {
        return globalParameters;
    }

    public void setGlobalParameters(SecuredMessage globalParameters) {
        this.globalParameters = globalParameters;
    }

    public SecuredMessage getLocalParameters() {
        return localParameters;
    }

    public void setLocalParameters(SecuredMessage localParameters) {
        this.localParameters = localParameters;
    }

    public static LocalPolicyFile getInstance(byte[] data) throws Exception {
        LocalPolicyFile localPolicyFile = new LocalPolicyFile();
        SecuredMessage globalParameters = SecuredMessage.getInstance(data);
        SecuredMessage localParameters = SecuredMessage.getInstance(globalParameters.getGoal());
        localPolicyFile.setGlobalParameters(globalParameters);
        localPolicyFile.setLocalParameters(localParameters);
        localPolicyFile.setGoal(localParameters.getGoal());
        return localPolicyFile;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(globalParameters);
        vector.add(localParameters);
        return vector;
    }
}
