package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.Choice;
import org.bouncycastle.util.BigIntegers;

import java.math.BigInteger;
import java.util.Vector;

/**
 * 策略类型结构体定义
 * Policy ::= CHOICE {
 * global  GlobalPolicyData,
 * custom  CustomPolicyData,--ECA或PCA签名
 * local   LocalPolicyData,-- ECA或PCA签名
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName Policy
 * @Date 2019/12/24 11:19
 */
public class Policy extends Choice {
    private GlobalPolicyData global;
    private CustomPolicyData custom;
    private LocalPolicyData local;

    public GlobalPolicyData getGlobal() {
        return global;
    }

    public void setGlobal(GlobalPolicyData global) {
        this.addIndex(0);
        this.global = global;
    }

    public CustomPolicyData getCustom() {
        return custom;
    }

    public void setCustom(CustomPolicyData custom) {
        this.addIndex(1);
        this.custom = custom;
    }

    public LocalPolicyData getLocal() {
        return local;
    }

    public void setLocal(LocalPolicyData local) {
        this.addIndex(2);
        this.local = local;
    }

    public static Policy getInstance(byte[] data) throws Exception {
        Policy policy = new Policy();
        BigInteger choice = BigIntegers.fromUnsignedByteArray(data, 0, 1);
        byte[] goal = new byte[data.length - 1];
        System.arraycopy(data, 1, goal, 0, goal.length);
        if (choice.intValue() - 0x80 == 0) {
            GlobalPolicyData globalPolicyData = GlobalPolicyData.getInstance(goal);
            policy.setGlobal(globalPolicyData);
            policy.setGoal(globalPolicyData.getGoal());
        } else if (choice.intValue() - 0x80 == 1) {
            CustomPolicyData customPolicyData = CustomPolicyData.getInstance(goal);
            policy.setCustom(customPolicyData);
            policy.setGoal(customPolicyData.getGoal());
        } else if (choice.intValue() - 0x80 == 2) {
            LocalPolicyData localPolicyData = LocalPolicyData.getInstance(goal);
            policy.setLocal(localPolicyData);
            policy.setGoal(localPolicyData.getGoal());
        } else {
            throw new Exception("unsupported Policy type " + choice.intValue());
        }
        return policy;
    }

    @Override
    public Vector getChoiceValues() {
        Vector vector = new Vector();
        vector.add(global);
        vector.add(custom);
        vector.add(local);
        return vector;
    }
}
