package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.base.Sequence;
import com.xdja.pki.oer.gbt.asn1.Time64;
import org.bouncycastle.util.BigIntegers;

import java.util.Vector;

/**
 * 待签名策略数据结构体定义
 * ToBeSignedPolicyData ::= SEQUENCE {
 * policyID OCTET STRING (SIZE (0..32)),--政策文件唯一标识符
 * generationTime Time64,--政策文件生成时间
 * policy Policy,--策略
 * }
 *
 * @author wzs
 * @version v1.0
 * @ClassName ToBeSignedPolicyData
 * @Date 2019/12/24 11:19
 */
public class ToBeSignedPolicyData extends Sequence {
    private OctetString policyID;
    private Time64 generationTime;
    private Policy policy;

    public ToBeSignedPolicyData(boolean isExtension, boolean hasOptional) {
        super(isExtension, hasOptional);
    }

    public ToBeSignedPolicyData() {
        super(false, false);
    }

    public OctetString getPolicyID() {
        return policyID;
    }

    public void setPolicyID(OctetString policyID) {
        this.policyID = policyID;
    }

    public Time64 getGenerationTime() {
        return generationTime;
    }

    public void setGenerationTime(Time64 generationTime) {
        this.generationTime = generationTime;
    }

    public Policy getPolicy() {
        return policy;
    }

    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    public static ToBeSignedPolicyData getInstance(byte[] data) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        OctetString policyID = OctetString.getInstance(data);
        toBeSignedPolicyData.setPolicyID(policyID);
        byte[] generationTimeBytes = new byte[8];
        System.arraycopy(policyID.getGoal(), 0, generationTimeBytes, 0, generationTimeBytes.length);
        Time64 generationTime = new Time64(BigIntegers.fromUnsignedByteArray(generationTimeBytes).longValue());
        toBeSignedPolicyData.setGenerationTime(generationTime);
        byte[] goal = new byte[policyID.getGoal().length - 8];
        System.arraycopy(policyID.getGoal(), 8, goal, 0, goal.length);
        Policy policy = Policy.getInstance(goal);
        toBeSignedPolicyData.setPolicy(policy);
        toBeSignedPolicyData.setGoal(policy.getGoal());
        return toBeSignedPolicyData;
    }

    @Override
    public Vector getSequenceValues() {
        Vector vector = new Vector();
        vector.add(policyID);
        vector.add(generationTime);
        vector.add(policy);
        return vector;
    }
}
