package com.xdja.pki.oer.batc.lpf;

import com.xdja.pki.oer.base.OctetString;
import com.xdja.pki.oer.core.TimeUtils;
import com.xdja.pki.oer.gbt.asn1.Time64;

import java.io.IOException;
import java.util.UUID;

/**
 * 待签名策略数据构建类
 *
 * @author wzs
 * @version v1.0
 * @ClassName ToBeSignedPolicyDataBuilder
 * @Date 2020/01/04 11:19
 */
public class ToBeSignedPolicyDataBuilder {
    /**
     * 创建全局策略数据
     *
     * @param globalPolicyData
     * @return
     * @throws Exception
     */
    public static ToBeSignedPolicyData buildGlobal(GlobalPolicyData globalPolicyData) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        Policy policy = new Policy();
        policy.setGlobal(globalPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }

    /**
     * 创建自定义策略数据
     *
     * @param globalPolicyData
     * @param hostname
     * @return
     * @throws Exception
     */
    public static ToBeSignedPolicyData buildCustom(GlobalPolicyData globalPolicyData, String hostname) throws Exception {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        CustomPolicyData customPolicyData = new CustomPolicyData();
        OctetString octetString = new OctetString();
        octetString.setString(hostname.getBytes());
        customPolicyData.setHostname(octetString);
        customPolicyData.setGlobalPolicy(globalPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        Policy policy = new Policy();
        policy.setCustom(customPolicyData);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }

    /**
     * 创建本地策略数据
     *
     * @param localPolicyData
     * @return
     * @throws IOException
     */
    public static ToBeSignedPolicyData buildLocal(LocalPolicyData localPolicyData) throws IOException {
        ToBeSignedPolicyData toBeSignedPolicyData = new ToBeSignedPolicyData();
        Policy policy = new Policy();
        policy.setLocal(localPolicyData);
        OctetString policyId = new OctetString();
        policyId.setString(UUID.randomUUID().toString().getBytes());
        toBeSignedPolicyData.setPolicyID(policyId);
        toBeSignedPolicyData.setPolicy(policy);
        long l = TimeUtils.getNowTime() * 1000;
        toBeSignedPolicyData.setGenerationTime(new Time64(l));
        return toBeSignedPolicyData;
    }
}
