package com.xdja.pki.oer.batc.utils;

import com.xdja.pki.oer.gbt.asn1.Certificate;
import com.xdja.pki.oer.gbt.asn1.TbsCert;
import com.xdja.pki.oer.gbt.asn1.utils.CertificateBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.TbsCertBuilder;
import com.xdja.pki.oer.gbt.asn1.utils.enums.BATCSubjectTypeEnum;
import com.xdja.pki.oer.gbt.asn1.utils.enums.CertHashTypeEnum;

import java.security.PrivateKey;
import java.security.PublicKey;

/**
 * @ClassName BATCCertificateBuilder
 * @Description TODO
 * @Date 2020/3/25 14:40
 * @Author FengZhen
 */
public class BATCCertificateBuilder extends CertificateBuilder {
    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, byte[] issuedHashId, BATCSubjectTypeEnum subjectType) throws Exception {
        return build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, byte[] issuedHashId, BATCSubjectTypeEnum subjectType) throws Exception {
        return build(privateKey, verifyPublicKey, encPublicKey, subjectName, CertHashTypeEnum.SGD_SM3, issuedHashId, subjectType);
    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, String subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, BATCSubjectTypeEnum subjectType) throws Exception {
        return build(privateKey, verifyPublicKey, encPublicKey, subjectName.getBytes(), hashType, issuedHashId, subjectType);

    }

    public Certificate build(PrivateKey privateKey, PublicKey verifyPublicKey, PublicKey encPublicKey, byte[] subjectName, CertHashTypeEnum hashType, byte[] issuedHashId, BATCSubjectTypeEnum subjectType) throws Exception {

        TbsCertBuilder tbsCertBuilder = new TbsCertBuilder();
        if (null != this.getEndTime()) {
            tbsCertBuilder.setEndTime(this.getEndTime());
        }
        if (null != this.getStartTime()) {
            tbsCertBuilder.setStartTime(this.getStartTime());
        }
        if (this.getItsAidList() != null) {
            tbsCertBuilder.setItsAidList(this.getItsAidList());
        }
        if (this.getItsAidSspList() != null) {
            tbsCertBuilder.setItsAidSspList(this.getItsAidSspList());
        }
        if (this.getGeographicRegion() != null) {
            tbsCertBuilder.setGeographicRegion(this.getGeographicRegion());
        }
        tbsCertBuilder.setSignKeyEccPointType(this.getSignKeyEccPointType());
        tbsCertBuilder.setEncKeyEccPointType(this.getEncKeyEccPointType());
        tbsCertBuilder.setEccCurveTypeEnum(this.getEccCurveTypeEnum());

        TbsCert tbsCert = tbsCertBuilder.build(verifyPublicKey, encPublicKey, subjectName, subjectType);

        return build(privateKey, hashType, issuedHashId, tbsCert);
    }
}
