/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.dao;

import com.xdja.pki.ldap.X509Utils;
import com.xdja.pki.ldap.config.OpenLDAPConfiguration;
import com.xdja.pki.ldap.config.StoreDRLException;
import com.xdja.pki.ldap.dao.IDAO;
import com.xdja.pki.ldap.dao.SpringLDAPConnect;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.x509.X500Name;

@Repository
public class LDAPDAO
implements IDAO {
    private Logger logger = LoggerFactory.getLogger(LDAPDAO.class);
    private SpringLDAPConnect ldapConnect;

    public LDAPDAO(@Autowired OpenLDAPConfiguration openLDAPConfiguration) {
        this.ldapConnect = new SpringLDAPConnect(openLDAPConfiguration.getHost(), openLDAPConfiguration.getPort(), openLDAPConfiguration.getRootDn(), openLDAPConfiguration.getRootPassword(), openLDAPConfiguration.getContainerName());
    }

    @Override
    public void init(X509Certificate rootCA) throws Exception {
        this.logger.debug("-----\u521d\u59cb\u5316\u670d\u52a1\u5668\u5f00\u59cb------");
        this.clear();
        this.addCertEntry(rootCA);
    }

    @Override
    public void updateRootCACertificate(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) throws Exception {
        this.addCertEntry(oldWithNew);
        this.addCertEntry(newWithOld);
        this.addCertEntry(newWithNew);
    }

    @Override
    public void sendCertificate(X509Certificate certificate) throws Exception {
        this.addCertEntry(certificate);
    }

    @Override
    public void sendInvaildCertificateSN(String[] sns) {
    }

    @Override
    public void sendCRL(int crlSegment, X509CRL crl) throws Exception {
        this.addCRLEntry(crlSegment, crl);
    }

    @Override
    public void sendCrossCertificate(X509CertificatePair pair) throws Exception {
        String dn;
        X509Certificate forward = pair.getForward();
        if (forward != null) {
            dn = forward.getSubjectX500Principal().getName();
        } else {
            X509Certificate re = pair.getReverse();
            if (re != null) {
                dn = re.getIssuerX500Principal().getName();
            } else {
                this.logger.error("pair is null");
                throw new Exception("pair is null");
            }
        }
        X500Name name = new X500Name(dn);
        String cn = name.getCommonName();
        this.ldapConnect.addCrossCertEntry(dn, cn, pair.getEncoded());
    }

    private void clear() {
        this.ldapConnect.deleteAll();
    }

    private void addCertEntry(X509Certificate certificate) throws Exception {
        String dn = certificate.getSubjectX500Principal().getName();
        LdapName ldapName = new LdapName(dn);
        Rdn endRdn = ldapName.getRdn(ldapName.size() - 1);
        String cn = (String)endRdn.getValue();
        if (X509Utils.isCACertificate((X509Certificate)certificate)) {
            this.ldapConnect.addCACertEntry(dn, cn, certificate.getEncoded());
        } else {
            this.ldapConnect.addUserCertEntry(dn, cn, certificate.getEncoded());
        }
    }

    private void addCRLEntry(int clrSegment, X509CRL crl) throws Exception {
        String issuer = crl.getIssuerX500Principal().getName();
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (X509Utils.isARL((X509CRL)crl)) {
            String cn = "arl" + clrSegment;
            String dn = "cn=" + cn + ",o=" + rdn.getValue() + "ARL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165ARL");
            this.ldapConnect.addARLEntry(dn, cn, crl.getEncoded());
        } else if (X509Utils.isDRL((X509CRL)crl)) {
            this.addDRLEntry(clrSegment, crl);
        } else {
            String cn = "crl" + clrSegment;
            String dn = "cn=" + cn + ",o=" + rdn.getValue() + "CRL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165CRL");
            this.ldapConnect.addCRLEntry(dn, cn, crl.getEncoded());
        }
    }

    private void addDRLEntry(int clrSegment, X509CRL crl) throws Exception {
        String issuer = crl.getIssuerX500Principal().getName();
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        byte[] deltaCRLIndicator = crl.getExtensionValue(Extension.deltaCRLIndicator.getId());
        byte[] drlBaseOctet = DEROctetString.getInstance((Object)deltaCRLIndicator).getOctets();
        CRLNumber baseCrlNumber = CRLNumber.getInstance((Object)drlBaseOctet);
        String cn = "crl" + clrSegment;
        String dn = "cn=" + cn + ",o=" + rdn.getValue() + "CRL" + issuer.replace(rdnString, "");
        X509CRL getCrl = this.ldapConnect.searchCrlEntry(dn, "certificateRevocationList;binary");
        StoreDRLException status = StoreDRLException.ARL_AND_CRL_NOT_FOUND;
        if (getCrl != null) {
            byte[] extensionValue = getCrl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH;
        }
        cn = "arl" + clrSegment;
        dn = "cn=" + cn + ",o=" + rdn.getValue() + "ARL" + issuer.replace(rdnString, "");
        X509CRL getArl = this.ldapConnect.searchCrlEntry(dn, "authorityRevocationList;binary");
        if (getArl != null) {
            byte[] extensionValue = getArl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH.equals((Object)status) ? StoreDRLException.CRL_AND_ARL_NOT_MATCH : StoreDRLException.ARL_NOT_MATCH;
        }
        this.logger.error(status.getDescription());
        throw new Exception(status.getDescription());
    }
}

