/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.dao;

import com.xdja.pki.ldap.X509Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertPairParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.DefaultDirObjectFactory;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import sun.security.provider.certpath.X509CertificatePair;

public class SpringLDAPConnect {
    private LdapTemplate ldapTemplate;
    private String containerName;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public SpringLDAPConnect(String ldapHost, int ldapPort, String loginDN, String password, String containerName) {
        try {
            LdapContextSource lcs = new LdapContextSource();
            lcs.setUrl("ldap://" + ldapHost + ":" + ldapPort);
            lcs.setUserDn(loginDN);
            lcs.setPassword(password);
            lcs.setDirObjectFactory(DefaultDirObjectFactory.class);
            lcs.afterPropertiesSet();
            this.ldapTemplate = new LdapTemplate((ContextSource)lcs);
            this.containerName = containerName;
            this.logger.info("\u8fde\u63a5ldap\u670d\u52a1\u5668\u6210\u529f");
        }
        catch (Exception e) {
            this.logger.error("\u8fde\u63a5ldap\u670d\u52a1\u5668\u5931\u8d25");
            e.printStackTrace();
        }
    }

    public void deleteAll() {
        try {
            this.ldapTemplate.unbind(this.containerName, true);
            this.logger.info("-------\u5df2\u6e05\u7a7a\u670d\u52a1\u5668 " + this.containerName + "\u8282\u70b9\u4e0b\u6240\u6709\u6570\u636e---------");
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public X509CRL searchCrlEntry(String dn, String name) throws Exception {
        Attributes attributes;
        if (!dn.toUpperCase().endsWith(this.containerName.toUpperCase())) {
            dn = dn + "," + this.containerName;
        }
        this.logger.info("search dn is {}", (Object)dn);
        try {
            attributes = (Attributes)this.ldapTemplate.searchForObject(LdapQueryBuilder.query().base(dn).filter("(objectClass=*)"), (ContextMapper)new ContextMapper<Attributes>(){

                public Attributes mapFromContext(Object ctx) {
                    return ((DirContextAdapter)ctx).getAttributes();
                }
            });
        }
        catch (NameNotFoundException e) {
            return null;
        }
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        NamingEnumeration<String> iDs = attributes.getIDs();
        while (iDs.hasMore()) {
            NamingEnumeration<?> all;
            String id = iDs.next();
            if (!id.equalsIgnoreCase(name) || !(all = attributes.get(id).getAll()).hasMore()) continue;
            return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream((byte[])all.next()));
        }
        this.logger.error("\u6ca1\u6709\u67e5\u5230\u8be5\u8282\u70b9\uff1a" + name);
        throw new Exception("\u6ca1\u6709\u67e5\u5230\u8be5\u8282\u70b9\uff1a" + name);
    }

    public void addCACertEntry(String dn, String cn, byte[] certBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute attr = new BasicAttribute("objectclass");
        attr.add("pkiCA");
        attr.add("organizationalRole");
        attrs.put(attr);
        attrs.put("cn", cn);
        attrs.put("cACertificate;binary", certBinary);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165CA\u8bc1\u4e66");
        this.addEntry(dn, attrs);
    }

    public void addUserCertEntry(String dn, String cn, byte[] certBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        attrs.put("objectclass", "inetOrgPerson");
        attrs.put("userCertificate;binary", certBinary);
        attrs.put("cn", cn);
        attrs.put("sn", cn);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165\u7528\u6237\u8bc1\u4e66");
        this.addEntry(dn, attrs);
    }

    public void addARLEntry(String dn, String cn, byte[] crlBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        attrs.put("objectclass", "cRLDistributionPoint");
        attrs.put("cn", cn);
        attrs.put("authorityRevocationList;binary", crlBinary);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165arl");
        this.addEntry(dn, attrs);
    }

    public void addDRLEntry(String dn, String cn, byte[] crlBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        attrs.put("objectclass", "cRLDistributionPoint");
        attrs.put("cn", cn);
        attrs.put("deltaRevocationList;binary", crlBinary);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165drl");
        this.addEntry(dn, attrs);
    }

    public void addCRLEntry(String dn, String cn, byte[] crlBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        attrs.put("objectclass", "cRLDistributionPoint");
        attrs.put("cn", cn);
        attrs.put("certificateRevocationList;binary", crlBinary);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165crl");
        this.addEntry(dn, attrs);
    }

    public void addCrossCertEntry(String dn, String cn, byte[] pairBinary) throws Exception {
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = dn.replace("dnqualifier".toUpperCase(), "displayName".toUpperCase());
        if (this.selectCrossCert(dn = dn.replace("e".toUpperCase(), "mail".toUpperCase())) != null) {
            this.logger.error("\u8be5\u8282\u70b9\u5df2\u7ecf\u6709\u4e00\u4e2a\u4ea4\u53c9\u8bc1\u4e66\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d2\u5165");
            throw new Exception("\u8be5\u8282\u70b9\u5df2\u7ecf\u6709\u4e00\u4e2a\u4ea4\u53c9\u8bc1\u4e66\uff0c\u65e0\u6cd5\u7ee7\u7eed\u63d2\u5165");
        }
        this.logger.debug("\u8be5\u8282\u70b9\u6ca1\u6709\u4ea4\u53c9\u8bc1\u4e66");
        this.addCrossCert(dn, cn, pairBinary);
    }

    public void addForwardCert(String dn, String cn, X509Certificate forward) throws Exception {
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = dn.replace("dnqualifier".toUpperCase(), "displayName".toUpperCase());
        boolean b = this.checkExist(dn = dn.replace("e".toUpperCase(), "mail".toUpperCase()));
        if (b) {
            X509CertificatePair crossPair;
            if (this.selectCrossCert(dn) == null) {
                this.logger.debug("\u8bf4\u660e\u8be5\u8282\u70b9\u6ca1\u6709\u4ea4\u53c9\u8bc1\u4e66,\u53ef\u4ee5\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66forward");
                this.addCrossCert(dn, cn, new X509CertificatePair(forward, null).getEncoded());
            }
            if ((crossPair = this.selectCrossCert(dn)).getForward() != null) {
                this.logger.error("\u8be5\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\u4ea4\u53c9\u8bc1\u4e66\u7684forward,\u4e0d\u80fd\u7ee7\u7eed\u63d2\u5165");
                throw new Exception("\u8be5\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\u4ea4\u53c9\u8bc1\u4e66\u7684forward,\u4e0d\u80fd\u7ee7\u7eed\u63d2\u5165");
            }
            if (crossPair.getReverse() != null) {
                try {
                    X509CertificatePair pair = new X509CertificatePair(forward, crossPair.getReverse());
                    byte[] pairBinary = pair.getEncoded();
                    this.logger.debug("\u5f00\u59cb\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66forward");
                    this.addCrossCert(dn, cn, pairBinary);
                }
                catch (CertificateException e) {
                    this.logger.error("crossPair.getForward().getIssuerX500Principal() " + forward.getSubjectX500Principal());
                    this.logger.error("crossPair.getReverse().getIssuerX500Principal() " + crossPair.getReverse().getIssuerX500Principal());
                    this.logger.error("\u8be5\u8bc1\u4e66\u65e0\u6cd5\u4e0e\u670d\u52a1\u5668\u7684Forward\u8bc1\u4e66\u6784\u6210\u4ea4\u53c9\u8bc1\u4e66\u5bf9", (Throwable)e);
                    throw new Exception("can't use these two certs build X509CertificatePair");
                }
            }
        } else {
            this.logger.debug("\u8bf4\u660e\u4e0d\u5b58\u5728\u8be5\u8282\u70b9,\u53ef\u4ee5\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66forward");
            this.addCrossCert(dn, cn, new X509CertificatePair(forward, null).getEncoded());
        }
    }

    public void addReserveCert(String dn, String cn, X509Certificate reserve) throws Exception {
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = dn.replace("dnqualifier".toUpperCase(), "displayName".toUpperCase());
        boolean b = this.checkExist(dn = dn.replace("e".toUpperCase(), "mail".toUpperCase()));
        if (b) {
            X509CertificatePair crossPair;
            if (this.selectCrossCert(dn) == null) {
                this.logger.debug("\u8bf4\u660e\u8be5\u8282\u70b9\u6ca1\u6709\u4ea4\u53c9\u8bc1\u4e66,\u53ef\u4ee5\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66reserve");
                this.addCrossCert(dn, cn, new X509CertificatePair(null, reserve).getEncoded());
            }
            if ((crossPair = this.selectCrossCert(dn)).getReverse() != null) {
                this.logger.error("\u8be5\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\u4ea4\u53c9\u8bc1\u4e66\u7684reserve,\u4e0d\u80fd\u7ee7\u7eed\u63d2\u5165");
                throw new Exception("\u8be5\u8282\u70b9\u5df2\u7ecf\u5b58\u5728\u4ea4\u53c9\u8bc1\u4e66\u7684reserve,\u4e0d\u80fd\u7ee7\u7eed\u63d2\u5165");
            }
            if (crossPair.getForward() != null) {
                try {
                    X509CertificatePair pair = new X509CertificatePair(crossPair.getForward(), reserve);
                    byte[] pairBinary = pair.getEncoded();
                    this.logger.debug("\u5f00\u59cb\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66reserve");
                    this.addCrossCert(dn, cn, pairBinary);
                }
                catch (CertificateException e) {
                    this.logger.error("crossPair.getForward().getIssuerX500Principal() " + crossPair.getForward().getSubjectX500Principal());
                    this.logger.error("crossPair.getReverse().getIssuerX500Principal() " + reserve.getIssuerX500Principal());
                    this.logger.error("\u8be5\u8bc1\u4e66\u65e0\u6cd5\u4e0e\u670d\u52a1\u5668\u7684Forward\u8bc1\u4e66\u6784\u6210\u4ea4\u53c9\u8bc1\u4e66\u5bf9 ", (Throwable)e);
                    throw new Exception("can't use these two certs build X509CertificatePair");
                }
            }
        } else {
            this.logger.debug("\u8bf4\u660e\u4e0d\u5b58\u5728\u8be5\u8282\u70b9,\u53ef\u4ee5\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66reserve");
            this.addCrossCert(dn, cn, new X509CertificatePair(null, reserve).getEncoded());
        }
    }

    private void addCrossCert(String dn, String cn, byte[] pairBinary) throws Exception {
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute attr = new BasicAttribute("objectclass", "organizationalRole");
        attr.add("pkiCA");
        attrs.put(attr);
        attrs.put("cn", cn);
        attrs.put("crossCertificatePair;binary", pairBinary);
        this.logger.debug("\u5f00\u59cb\u63d2\u5165\u4ea4\u53c9\u8bc1\u4e66\u5bf9");
        this.addEntry(dn, attrs);
    }

    private void addEntry(String dn, Attributes attrs) throws Exception {
        boolean exist;
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = dn.replace("dnqualifier".toUpperCase(), "displayName".toUpperCase());
        if (!(dn = dn.replace("e".toUpperCase(), "mail".toUpperCase())).toUpperCase().endsWith("," + this.containerName.toUpperCase())) {
            dn = dn + "," + this.containerName;
            this.logger.debug("\u8bc1\u4e66dn\u4fee\u6539\u540e\u4e3a " + dn);
        }
        if (exist = this.checkExist(dn)) {
            DirContextAdapter old = (DirContextAdapter)this.ldapTemplate.lookup(dn);
            Object[] objectclass = old.getObjectAttributes("objectclass");
            ArrayList<String> oldValue = new ArrayList<String>();
            for (int i = 0; i < objectclass.length; ++i) {
                oldValue.add((String)objectclass[i]);
            }
            try {
                Attribute attr;
                ArrayList<ModificationItem> list = new ArrayList<ModificationItem>();
                ArrayList<String> newValue = new ArrayList<String>();
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMoreElements()) {
                    String attrStr;
                    attr = ae.next();
                    if (!attr.getID().contains("objectclass") || newValue.contains(attrStr = (String)attr.get())) continue;
                    newValue.add(attrStr);
                }
                if (oldValue.contains("pkiCA") && newValue.contains("inetOrgPerson")) {
                    attrs.remove("cn");
                    attrs.remove("sn");
                }
                ae = attrs.getAll();
                while (ae.hasMoreElements()) {
                    ModificationItem item;
                    attr = ae.next();
                    if (attr.getID().contains("objectclass")) {
                        BasicAttribute attribute;
                        String o = (String)attr.get();
                        if (oldValue.contains("person") && oldValue.contains("pkiCA") && o.equalsIgnoreCase("pkiCA")) continue;
                        if (oldValue.contains("person") && o.equalsIgnoreCase("pkiCA")) {
                            attribute = new BasicAttribute("objectclass");
                            attribute.add("pkiCA");
                            item = new ModificationItem(1, attribute);
                            list.add(item);
                            continue;
                        }
                        if (oldValue.contains("person") && oldValue.contains("pkiUser")) continue;
                        if (oldValue.contains("person")) {
                            attribute = new BasicAttribute("objectclass");
                            attribute.add("pkiUser");
                            item = new ModificationItem(1, attribute);
                            list.add(item);
                            continue;
                        }
                        if (oldValue.contains("pkiCA") && o.equalsIgnoreCase("inetOrgPerson")) {
                            if (oldValue.contains("pkiUser")) continue;
                            attribute = new BasicAttribute("objectclass");
                            attribute.add("pkiUser");
                            item = new ModificationItem(1, attribute);
                            list.add(item);
                            continue;
                        }
                    }
                    item = attr.getID().contains("userCertificate;binary") || attr.getID().contains("cACertificate;binary") ? new ModificationItem(1, attr) : new ModificationItem(2, attr);
                    list.add(item);
                }
                ModificationItem[] items = new ModificationItem[list.size()];
                this.ldapTemplate.modifyAttributes(dn, list.toArray(items));
                this.logger.info("\u66f4\u65b0 " + dn + " \u8282\u70b9\u6210\u529f");
            }
            catch (Exception e) {
                if (e.getMessage().contains("LDAP: error code 20")) {
                    this.logger.info("\u8282\u70b9 " + dn + " \u6570\u636e\u5df2\u5b58\u5728 \u4e0d\u518d\u63d2\u5165");
                }
                this.logger.error("\u4fee\u6539" + dn + "\u8282\u70b9\u5931\u8d25", (Throwable)e);
                throw new Exception("\u4fee\u6539" + dn + "\u8282\u70b9\u5931\u8d25", e);
            }
        } else {
            this.addPoint(dn, attrs);
        }
    }

    private void addPoint(String dn, Attributes attributes) throws Exception {
        if (!dn.toUpperCase().endsWith("," + this.containerName.toUpperCase())) {
            dn = dn + "," + this.containerName;
        }
        LdapName ldapName = new LdapName(dn);
        int posn = 0;
        Rdn rdn = ldapName.getRdn(posn);
        String getdn = rdn + "";
        while (!getdn.equalsIgnoreCase(this.containerName)) {
            if (++posn >= ldapName.size()) {
                this.logger.error("\u4f20\u5165\u7684dn\u4e0d\u662f\u4ee5" + this.containerName + "\u7ed3\u5c3e\u7684");
                throw new Exception("this dn is false " + dn + " " + getdn + " " + this.containerName);
            }
            rdn = ldapName.getRdn(posn);
            getdn = rdn + "," + getdn;
        }
        while (posn <= ldapName.size()) {
            this.logger.debug("\u5f53\u524d\u5f97\u5230\u7684dn\u8282\u70b9\u4e3a " + getdn);
            boolean isExist = this.checkExist(getdn);
            if (!isExist) {
                if (getdn.equalsIgnoreCase(dn)) {
                    this.ldapTemplate.bind(getdn, null, attributes);
                    this.logger.info("\u6dfb\u52a0 " + dn + "\u8282\u70b9\u6210\u529f");
                    break;
                }
                BasicAttributes attrs = new BasicAttributes();
                if (rdn.getType().equalsIgnoreCase("ou")) {
                    attrs.put("objectclass", "organizationalUnit");
                } else if (rdn.getType().equalsIgnoreCase("o")) {
                    attrs.put("objectclass", "organization");
                } else if (rdn.getType().equalsIgnoreCase("L")) {
                    attrs.put("objectclass", "locality");
                } else if (rdn.getType().equalsIgnoreCase("st")) {
                    attrs.put("objectclass", "locality");
                } else if (rdn.getType().equalsIgnoreCase("c")) {
                    attrs.put("objectclass", "country");
                } else if (rdn.getType().equalsIgnoreCase("dc")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "domain");
                    attrs.put("dc", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("displayName")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "inetOrgPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("givenname")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "inetOrgPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("initials")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "inetOrgPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("sn")) {
                    attrs.put("objectclass", "person");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("street")) {
                    attrs.put("objectclass", "locality");
                } else if (rdn.getType().equalsIgnoreCase("title")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "organizationalPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("telephonenumber")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "organizationalPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("uid")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "inetOrgPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("mail")) {
                    attrs.put("objectclass", "top");
                    attrs.put("objectclass", "inetOrgPerson");
                    attrs.put("sn", rdn.getValue());
                    attrs.put("cn", rdn.getValue());
                } else if (rdn.getType().equalsIgnoreCase("cn")) {
                    attrs.put("objectclass", "person");
                    attrs.put("sn", rdn.getValue());
                } else {
                    this.logger.error("\u8be5rdn\u7c7b\u578b\u672a\u5b9a\u4e49  " + rdn.getType());
                    throw new Exception("unknown this type " + rdn.getType());
                }
                this.ldapTemplate.bind(getdn, null, (Attributes)attrs);
            }
            rdn = ldapName.getRdn(posn + 1);
            getdn = rdn + "," + getdn;
            ++posn;
        }
    }

    private boolean checkExist(String dn) {
        dn = X509Utils.transformCommaInDNValues((String)dn);
        dn = dn.replace("dnqualifier".toUpperCase(), "displayName".toUpperCase());
        dn = dn.replace("e".toUpperCase(), "mail".toUpperCase());
        boolean exist = false;
        try {
            Object old = this.ldapTemplate.lookup(dn);
            System.out.println(old);
            if (old != null) {
                exist = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exist;
    }

    private X509CertificatePair selectCrossCert(String dn) {
        List list;
        this.logger.debug("\u5f00\u59cb\u67e5\u8be2");
        try {
            list = this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().base(dn).where("objectclass").is("pkiCA"), attrs -> {
                System.out.println(attrs);
                return (byte[])attrs.get("crosscertificatepair;binary").get();
            });
        }
        catch (Exception e) {
            this.logger.debug("\u6b64\u8282\u70b9\u4e0b\u67e5\u4e0d\u5230");
            return null;
        }
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            byte[] b = (byte[])iterator.next();
            X509CertPairParser parser = new X509CertPairParser();
            parser.engineInit((InputStream)new ByteArrayInputStream(b));
            try {
                org.bouncycastle.x509.X509CertificatePair pair = (org.bouncycastle.x509.X509CertificatePair)parser.engineRead();
                this.logger.debug("\u67e5\u5230\u4e86");
                X509CertificatePair p = new X509CertificatePair(pair.getForward(), pair.getReverse());
                return p;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

