package com.xdja.pki.ldap.config;

import com.xdja.pki.ldap.X509Utils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix = "openldap.server")
public class OpenLDAPConfiguration {
    private int port;
    private String host;
    private String rootDn;
    private String rootPassword;
    private String containerName;

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getRootDn() {
        return rootDn;
    }
    //对逗号进行转义
    public void setRootDn(String rootDn) {
        this.rootDn = X509Utils.transformCommaInDNValues(rootDn);
    }

    public String getRootPassword() {
        return rootPassword;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    public String getContainerName() {
        return containerName;
    }

    //对逗号进行转义
    public void setContainerName(String containerName) {
        this.containerName = X509Utils.transformCommaInDNValues(containerName);
    }
}
