package com.xdja.pki.ldap.dao;

import sun.security.provider.certpath.X509CertificatePair;

import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;

public interface IDAO {

    /**
     * 系统初始化时调用
     * @param rootCA 根CA证书
     * @throws Exception
     */
    void init(X509Certificate rootCA) throws Exception;

    /**
     * GM/T 0014-2012 5.3 CA与LDAP服务间相关协议 5.3.2 发布协议
     * TBSISSUE SEQUENCE
     * type 0：向LDAP更新根证书
     *
     * @param oldWithNew
     * @param newWithOld
     * @param newWithNew
     */
    void updateRootCACertificate(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) throws Exception;

    /**
     * GM/T 0014-2012 5.3 CA与LDAP服务间相关协议 5.3.2 发布协议
     * TBSISSUE SEQUENCE
     * type 1：向LDAP发送证书
     *
     * @param certificate
     */
    void sendCertificate(X509Certificate certificate) throws Exception;

    /**
     * GM/T 0014-2012 5.3 CA与LDAP服务间相关协议 5.3.2 发布协议
     * TBSISSUE SEQUENCE
     * type 2：向LDAP发送作废证书序列号
     * <p>
     * TODO: 暂不支持
     *
     * @param sns
     */
    void sendInvaildCertificateSN(String[] sns);

    /**
     * GM/T 0014-2012 5.3 CA与LDAP服务间相关协议 5.3.2 发布协议
     * TBSISSUE SEQUENCE
     * type 3：向LDAP发送作废证书链
     *
     * @param crl
     */
    void sendCRL(int clrSegment, X509CRL crl) throws Exception;

    /**
     * GM/T 0014-2012 5.3 CA与LDAP服务间相关协议 5.3.2 发布协议
     * TBSISSUE SEQUENCE
     * type 8：向LDAP发送交叉认证证书
     * LDAP自己用根证书与此包中的第一个证书组成 PKCS#7 证书发布链
     *
     * @param pair 交叉证书对
     */
    void sendCrossCertificate(X509CertificatePair pair) throws Exception;
}
