/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.dao;

import com.xdja.pki.ldap.RFC4519StyleUpperCase;
import com.xdja.pki.ldap.X509Utils;
import com.xdja.pki.ldap.config.OpenLDAPConfiguration;
import com.xdja.pki.ldap.config.StoreDRLException;
import com.xdja.pki.ldap.dao.IDAO;
import com.xdja.pki.ldap.dao.SpringLDAPConnect;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.CRLNumber;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import sun.security.provider.certpath.X509CertificatePair;

@Repository
public class LDAPDAO
implements IDAO {
    private Logger logger = LoggerFactory.getLogger(LDAPDAO.class);
    private SpringLDAPConnect ldapConnect;

    public LDAPDAO(@Autowired OpenLDAPConfiguration openLDAPConfiguration) {
        this.ldapConnect = new SpringLDAPConnect(openLDAPConfiguration.getHost(), openLDAPConfiguration.getPort(), openLDAPConfiguration.getRootDn(), openLDAPConfiguration.getRootPassword(), openLDAPConfiguration.getContainerName());
    }

    @Override
    public void init(X509Certificate rootCA) throws Exception {
        this.logger.debug("-----\u521d\u59cb\u5316\u670d\u52a1\u5668\u5f00\u59cb------");
        this.clear();
        this.addCertEntry(rootCA);
    }

    @Override
    public void updateRootCACertificate(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) throws Exception {
        this.addCertEntry(oldWithNew);
        this.addCertEntry(newWithOld);
        this.addCertEntry(newWithNew);
    }

    @Override
    public void sendCertificate(X509Certificate certificate) throws Exception {
        this.addCertEntry(certificate);
    }

    @Override
    public void sendInvaildCertificateSN(String[] sns) {
    }

    @Override
    public void sendCRL(int crlSegment, X509CRL crl) throws Exception {
        this.logger.info("clrSegment" + crlSegment);
        this.logger.info("\u53d1\u5e03\u7684crl\u4e3a" + crl);
        this.addCRLEntry(crlSegment, crl);
    }

    @Override
    public void sendCRL(int stateOrProvinceNum, int crlSegment, X509CRL crl) throws Exception {
        if (0 == stateOrProvinceNum) {
            this.sendCRL(crlSegment, crl);
        } else {
            this.logger.info("stateOrProvinceNum" + stateOrProvinceNum);
            this.logger.info("clrSegment" + crlSegment);
            this.logger.info("\u53d1\u5e03\u7684crl\u4e3a" + crl);
            this.addCRLEntry(stateOrProvinceNum, crlSegment, crl);
        }
    }

    @Override
    public void sendCrossCertificate(X509CertificatePair pair) throws Exception {
        X509Certificate forward = pair.getForward();
        X509Certificate reserve = pair.getReverse();
        if (forward != null && reserve == null) {
            this.sendForwardCert(forward);
        } else if (forward == null && reserve != null) {
            this.sendReserveCert(reserve);
        } else if (forward != null && reserve != null) {
            String dn = X509Utils.getSubjectByX509Cert((X509Certificate)forward);
            X500Name name = new X500Name(RFC4519StyleUpperCase.INSTANCE, dn);
            String cn = X509Utils.getCommonName((X500Name)name);
            this.ldapConnect.addCrossCertEntry(dn, cn, pair.getEncoded());
        } else {
            this.logger.error("can't insert");
            throw new Exception("can't insert");
        }
    }

    private void sendReserveCert(X509Certificate reserve) throws Exception {
        String dn = X509Utils.getIssuerByX509Cert((X509Certificate)reserve);
        X500Name name = new X500Name(RFC4519StyleUpperCase.INSTANCE, dn);
        String cn = X509Utils.getCommonName((X500Name)name);
        this.ldapConnect.addReserveCert(dn, cn, reserve);
    }

    private void sendForwardCert(X509Certificate forward) throws Exception {
        String dn = X509Utils.getSubjectByX509Cert((X509Certificate)forward);
        X500Name name = new X500Name(RFC4519StyleUpperCase.INSTANCE, dn);
        String cn = X509Utils.getCommonName((X500Name)name);
        this.ldapConnect.addForwardCert(dn, cn, forward);
    }

    private void clear() {
        this.ldapConnect.deleteAll();
    }

    private void addCertEntry(X509Certificate certificate) throws Exception {
        String dn = X509Utils.getSubjectByX509Cert((X509Certificate)certificate);
        System.out.println(dn);
        LdapName ldapName = new LdapName(dn);
        Rdn endRdn = ldapName.getRdn(ldapName.size() - 1);
        String cn = (String)endRdn.getValue();
        if (X509Utils.isCACertificate((X509Certificate)certificate)) {
            this.ldapConnect.addCACertEntry(dn, cn, certificate.getEncoded());
        } else {
            this.ldapConnect.addUserCertEntry(dn, cn, certificate.getEncoded());
        }
    }

    private void addCRLEntry(int crlSegment, X509CRL crl) throws Exception {
        String issuer = X509Utils.getIssuerByX509CRL((X509CRL)crl);
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (X509Utils.isARL((X509CRL)crl)) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165ARL");
            this.ldapConnect.addARLEntry(dn, cn, crl.getEncoded());
        } else if (X509Utils.isDRL((X509CRL)crl)) {
            this.addDRLEntry(crlSegment, crl);
        } else {
            String cn = "crl" + crlSegment;
            String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165CRL");
            this.ldapConnect.addCRLEntry(dn, cn, crl.getEncoded());
        }
    }

    private void addCRLEntry(int stateOrProvinceNum, int crlSegment, X509CRL crl) throws Exception {
        String issuer = X509Utils.getIssuerByX509CRL((X509CRL)crl);
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        if (X509Utils.isARL((X509CRL)crl)) {
            String cn = "arl" + crlSegment;
            String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165ARL");
            this.ldapConnect.addARLEntry(dn, cn, crl.getEncoded());
        } else if (X509Utils.isDRL((X509CRL)crl)) {
            this.addDRLEntry(stateOrProvinceNum, crlSegment, crl);
        } else {
            String cn = "crl" + crlSegment;
            String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issuer.replace(rdnString, "");
            this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165CRL");
            this.ldapConnect.addCRLEntry(dn, cn, crl.getEncoded());
        }
    }

    private void addDRLEntry(int crlSegment, X509CRL crl) throws Exception {
        String issuer = X509Utils.getIssuerByX509CRL((X509CRL)crl);
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        byte[] deltaCRLIndicator = crl.getExtensionValue(Extension.deltaCRLIndicator.getId());
        byte[] drlBaseOctet = DEROctetString.getInstance((Object)deltaCRLIndicator).getOctets();
        CRLNumber baseCrlNumber = CRLNumber.getInstance((Object)drlBaseOctet);
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issuer.replace(rdnString, "");
        X509CRL getCrl = this.ldapConnect.searchCrlEntry(dn, "certificateRevocationList;binary");
        if (null == getCrl) {
            this.logger.info("get crl is null");
        } else {
            this.logger.info("get crl is {}", (Object)getCrl);
        }
        StoreDRLException status = StoreDRLException.ARL_AND_CRL_NOT_FOUND;
        if (getCrl != null) {
            byte[] extensionValue = getCrl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            System.out.println(getCrl);
            System.out.println(crl);
            this.logger.info("crlInstance.getCRLNumber().  " + crlInstance.getCRLNumber());
            this.logger.info("baseCrlNumber.getCRLNumber(). " + baseCrlNumber.getCRLNumber());
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH;
        }
        cn = "arl" + crlSegment;
        dn = "cn=" + cn + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issuer.replace(rdnString, "");
        X509CRL getArl = this.ldapConnect.searchCrlEntry(dn, "authorityRevocationList;binary");
        if (null == getArl) {
            this.logger.info("get arl is null");
        } else {
            this.logger.info("get arl is {}", (Object)getArl);
        }
        if (getArl != null) {
            byte[] extensionValue = getArl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH.equals((Object)status) ? StoreDRLException.CRL_AND_ARL_NOT_MATCH : StoreDRLException.ARL_NOT_MATCH;
        }
        this.logger.error(status.getDescription());
        throw new Exception(status.getDescription());
    }

    private void addDRLEntry(int stateOrProvinceNum, int crlSegment, X509CRL crl) throws Exception {
        String issuer = X509Utils.getIssuerByX509CRL((X509CRL)crl);
        LdapName ldapName = new LdapName(issuer);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        byte[] deltaCRLIndicator = crl.getExtensionValue(Extension.deltaCRLIndicator.getId());
        byte[] drlBaseOctet = DEROctetString.getInstance((Object)deltaCRLIndicator).getOctets();
        CRLNumber baseCrlNumber = CRLNumber.getInstance((Object)drlBaseOctet);
        String cn = "crl" + crlSegment;
        String dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "CRL" + issuer.replace(rdnString, "");
        X509CRL getCrl = this.ldapConnect.searchCrlEntry(dn, "certificateRevocationList;binary");
        if (null == getCrl) {
            this.logger.info("get crl is null");
        } else {
            this.logger.info("get crl is {}", (Object)getCrl);
        }
        StoreDRLException status = StoreDRLException.ARL_AND_CRL_NOT_FOUND;
        if (getCrl != null) {
            byte[] extensionValue = getCrl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            System.out.println(getCrl);
            System.out.println(crl);
            this.logger.info("crlInstance.getCRLNumber().  " + crlInstance.getCRLNumber());
            this.logger.info("baseCrlNumber.getCRLNumber(). " + baseCrlNumber.getCRLNumber());
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH;
        }
        cn = "arl" + crlSegment;
        dn = "cn=" + cn + ",st=" + stateOrProvinceNum + ",o=" + X509Utils.transformCommaInDNValues((String)rdn.getValue().toString()) + "ARL" + issuer.replace(rdnString, "");
        X509CRL getArl = this.ldapConnect.searchCrlEntry(dn, "authorityRevocationList;binary");
        if (null == getArl) {
            this.logger.info("get arl is null");
        } else {
            this.logger.info("get arl is {}", (Object)getArl);
        }
        if (getArl != null) {
            byte[] extensionValue = getArl.getExtensionValue(Extension.cRLNumber.getId());
            byte[] octets = DEROctetString.getInstance((Object)extensionValue).getOctets();
            CRLNumber crlInstance = CRLNumber.getInstance((Object)octets);
            if (crlInstance.getCRLNumber().equals(baseCrlNumber.getCRLNumber())) {
                this.logger.debug("\u5f00\u59cb\u5411LDAP\u670d\u52a1\u5668\u4e2d\u63d2\u5165DRL");
                this.ldapConnect.addDRLEntry(dn, cn, crl.getEncoded());
                return;
            }
            status = StoreDRLException.CRL_NOT_MATCH.equals((Object)status) ? StoreDRLException.CRL_AND_ARL_NOT_MATCH : StoreDRLException.ARL_NOT_MATCH;
        }
        this.logger.error(status.getDescription());
        throw new Exception(status.getDescription());
    }
}

