package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssue;
import com.xdja.pki.ldap.utils.X509Utils;
import org.bouncycastle.asn1.ASN1Encoding;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

import java.security.KeyPair;
import java.security.cert.X509Certificate;

public class BasicPkixIssueBuilder {

    protected KeyPair keyPair;
    protected X509Certificate certificate;

    public BasicPkixIssueBuilder(KeyPair keyPair, X509Certificate certificate) {
        this.keyPair = keyPair;
        this.certificate = certificate;
    }

    // TODO: 2019/3/11 签名算法从证书中读取
    protected Signature getSignature(TBSIssue tbsIssue) throws Exception {
        System.out.println(this.certificate.getSerialNumber());
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
        //Signature(AlgorithmIdentifier signatureAlgorithm, DERBitString signature)
        java.security.Signature sig = java.security.Signature.getInstance("SM3withSM2", BouncyCastleProvider.PROVIDER_NAME);
        sig.initSign(keyPair.getPrivate());
        sig.update(tbsIssue.getEncoded(ASN1Encoding.DER));
        sig.update(signatureAlgorithm.getEncoded(ASN1Encoding.DER));
        byte[] sign = sig.sign();
        return new Signature(signatureAlgorithm, new DERBitString(sign), X509Utils.toSequence(new Certificate[]{X509Utils.convertCertificate(certificate)}));
    }
}
