package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.ASN1CRL;
import com.xdja.pki.asn1.issue.CertStatus;
import com.xdja.pki.asn1.issue.PkixIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.ldap.utils.X509Utils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.Certificate;

import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.*;

import static com.xdja.pki.issue.TBSIssueType.*;

public class PkixIssueReq extends BasicPkixIssue {

    public PkixIssueReq(byte[] request) throws IOException {
        this(new ASN1InputStream(request));
    }

    private PkixIssueReq(ASN1InputStream inputStream) throws IOException {
        this.issue = PkixIssueRequest.getInstance(inputStream.readObject());
    }

    PkixIssueReq(TBSIssueRequest tbsIssueRequest, Signature signature) {
        // PkixIssue(TBSIssueRequest pkixIssueInfo, AlgorithmIdentifier signatureAlgorithm, Signature caSignature)
        this.issue = new PkixIssueRequest(tbsIssueRequest, signature.getSignatureAlgorithm(), signature);
    }

    TBSIssueRequest getTBSIssueRequest() {
        return (TBSIssueRequest) this.issue.getTBSIssue();
    }

    public List<X509Certificate> getCertificateList() throws Exception {
        System.out.println(this.getTBSIssueType());
        if (!UPDATE_ROOT_CERTIFICATE.equals(this.getTBSIssueType())
                && !SEND_CERTIFICATE.equals(this.getTBSIssueType())
                && !SEND_CROSS_CERTIFICATE.equals(this.getTBSIssueType())) {
            throw new Exception("type error: want -> "
                    + UPDATE_ROOT_CERTIFICATE
                    + " or " + SEND_CERTIFICATE
                    + " or " + SEND_CROSS_CERTIFICATE
                    + " but is -> " + this.getTBSIssueType());
        }
        List<X509Certificate> certificates = new ArrayList<>();
        Certificate[] cs = this.getTBSIssueRequest().getCert();
        for (Certificate c : cs) {
            X509Certificate cert = X509Utils.convertCertificate(c);
            certificates.add(cert);
        }
        return certificates;
    }

    public List<PkixIssueCRL> getCRLList() throws Exception {
        if (!SEND_CRL.equals(this.getTBSIssueType())) {
            throw new Exception("type error");
        }

        List<PkixIssueCRL> list = new ArrayList<>();
        ASN1CRL[] cls = this.getTBSIssueRequest().getmCRL();
        for (ASN1CRL c : cls) {
            X509CRL crl = X509Utils.converCRL(c.getCertificateList());
            list.add(new PkixIssueCRL(c.getCRLSegment().getValue().intValue(), crl));
        }
        return list;
    }

    public List<CertStatus> getCertStatusList() throws Exception {
        if (!SEND_CERTIFICATE_STATUS.equals(this.getTBSIssueType())) {
            throw new Exception("type error");
        }

        return Arrays.asList(this.getTBSIssueRequest().getCertStatus());
    }
}
