package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.PkixIssueResponse;
import com.xdja.pki.asn1.issue.TBSIssueResponse;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.Signature;

import java.io.IOException;

public class PkixIssueResp extends BasicPkixIssue {

    public PkixIssueResp(byte[] response) throws IOException {
        this(new ASN1InputStream(response));
    }

    private PkixIssueResp(ASN1InputStream inputStream) throws IOException {
        this.issue = PkixIssueResponse.getInstance(inputStream.readObject());
    }

    PkixIssueResp(TBSIssueResponse tbsIssueResponse, Signature signature) {
        // PkixIssue(TBSIssueRequest pkixIssueInfo, AlgorithmIdentifier signatureAlgorithm, Signature caSignature)
        this.issue = new PkixIssueResponse(tbsIssueResponse, signature.getSignatureAlgorithm(), signature);
    }

    public TBSIssueResponseStatus getStatus() throws Exception {
        TBSIssueResponse tbsIssueResponse = (TBSIssueResponse) this.issue.getTBSIssue();
        return TBSIssueResponseStatus.decode(tbsIssueResponse.getResponseStatus());
    }
}
