package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssueResponse;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ocsp.Signature;

import java.security.KeyPair;
import java.security.cert.X509Certificate;

// TODO: 2019/2/21 签名运算后期需要调用加密机
public class PkixIssueRespBuilder extends BasicPkixIssueBuilder {

    public PkixIssueRespBuilder(KeyPair keyPair, X509Certificate certificate) {
        super(keyPair, certificate);
    }

    public PkixIssueResp build(TBSIssueType type, TBSIssueResponseStatus status) throws Exception {
        ASN1Integer typeASN1 = type.encode();
        ASN1OctetString transNonce = PkixIssueUtils.generateTransNonce();
        ASN1Integer number = new ASN1Integer(0);
        return this.build(typeASN1, transNonce, number, status);
    }

    public PkixIssueResp build(PkixIssueReq req, TBSIssueResponseStatus status) throws Exception {
        ASN1Integer typeASN1 = req.getPkixIssue().getTBSIssue().getType();
        ASN1OctetString transNonce = req.getPkixIssue().getTBSIssue().getTransNonce();
        ASN1Integer number = req.getPkixIssue().getTBSIssue().getNumber();
        return this.build(typeASN1, transNonce, number, status);
    }

    public PkixIssueResp build(ASN1Integer typeASN1, ASN1OctetString transNonce, ASN1Integer number, TBSIssueResponseStatus responseStatus) throws Exception {
        ASN1GeneralizedTime time = PkixIssueUtils.generateTime();
        // public TBSIssueResponse(ASN1Integer type, ASN1OctetString transNonce, ASN1Integer number, ASN1GeneralizedTime time, ASN1Integer responseStatus)
        TBSIssueResponse tbsIssueResponse = new TBSIssueResponse(typeASN1, transNonce, number, time, responseStatus.encode());
        Signature responseSignature = this.getSignature(tbsIssueResponse);
        return new PkixIssueResp(tbsIssueResponse, responseSignature);
    }


}
