package com.xdja.pki.issue;

import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;

import java.util.Date;
import java.util.Random;

class PkixIssueUtils {

    static ASN1OctetString generateTransNonce(){
        byte[] sampleNonce = new byte[16];
        Random rand = new Random();
        rand.nextBytes(sampleNonce);
        return new DEROctetString(sampleNonce);
    }

    static ASN1GeneralizedTime generateTime() {
        return new ASN1GeneralizedTime(new Date(System.currentTimeMillis()));
    }
}
