/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.PkixIssue;
import com.xdja.pki.issue.TBSIssueType;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class BasicPkixIssue {
    protected PkixIssue issue;

    BasicPkixIssue() {
    }

    boolean isSigned() {
        return this.issue.getSignature() != null;
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.issue.getSignature().getSignatureAlgorithm().getAlgorithm();
    }

    public PkixIssue getPkixIssue() {
        return this.issue;
    }

    public TBSIssueType getTBSIssueType() throws Exception {
        return TBSIssueType.decode(this.issue.getTBSIssue().getType());
    }

    public byte[] getSignatureValues() {
        if (!this.isSigned()) {
            return null;
        }
        return this.issue.getSignature().getSignature().getOctets();
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws Exception {
        if (!this.isSigned()) {
            throw new Exception("attempt to verify signature on unsigned object");
        }
        try {
            ContentVerifier verifier = verifierProvider.get(this.issue.getSignature().getSignatureAlgorithm());
            OutputStream out = verifier.getOutputStream();
            out.write(this.issue.getSignatureInfo());
            return verifier.verify(this.getSignatureValues());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public boolean isSignatureValid(KeyPair keyPair) throws Exception {
        return this.isSignatureValid(keyPair.getPublic());
    }

    public boolean isSignatureValid(PublicKey key) throws Exception {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(key);
        return this.isSignatureValid(verifierProvider);
    }

    public byte[] getEncoded() throws IOException {
        return this.issue.getEncoded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPkixIssue that = (BasicPkixIssue)o;
        return Objects.equals((Object)this.issue, (Object)that.issue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issue});
    }
}

