/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssue;
import com.xdja.pki.ldap.utils.X509Utils;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;

public class BasicPkixIssueBuilder {
    protected KeyPair keyPair;
    protected X509Certificate certificate;

    public BasicPkixIssueBuilder(KeyPair keyPair, X509Certificate certificate) {
        this.keyPair = keyPair;
        this.certificate = certificate;
    }

    protected Signature getSignature(TBSIssue tbsIssue) throws Exception {
        System.out.println(this.certificate.getSerialNumber());
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
        java.security.Signature sig = java.security.Signature.getInstance("SM3withSM2", "BC");
        sig.initSign(this.keyPair.getPrivate());
        sig.update(tbsIssue.getEncoded("DER"));
        sig.update(signatureAlgorithm.getEncoded("DER"));
        byte[] sign = sig.sign();
        return new Signature(signatureAlgorithm, new DERBitString(sign), (ASN1Sequence)X509Utils.toSequence((ASN1Encodable[])new Certificate[]{X509Utils.convertCertificate(this.certificate)}));
    }
}

