/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.ASN1CRL;
import com.xdja.pki.asn1.issue.CertStatus;
import com.xdja.pki.asn1.issue.PkixIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.issue.BasicPkixIssue;
import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.TBSIssueType;
import com.xdja.pki.ldap.utils.X509Utils;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.Certificate;

public class PkixIssueReq
extends BasicPkixIssue {
    public PkixIssueReq(byte[] request) throws IOException {
        this(new ASN1InputStream(request));
    }

    private PkixIssueReq(ASN1InputStream inputStream) throws IOException {
        this.issue = PkixIssueRequest.getInstance(inputStream.readObject());
    }

    PkixIssueReq(TBSIssueRequest tbsIssueRequest, Signature signature) {
        this.issue = new PkixIssueRequest(tbsIssueRequest, signature.getSignatureAlgorithm(), signature);
    }

    TBSIssueRequest getTBSIssueRequest() {
        return (TBSIssueRequest)this.issue.getTBSIssue();
    }

    public List<X509Certificate> getCertificateList() throws Exception {
        Certificate[] cs;
        System.out.println((Object)this.getTBSIssueType());
        if (!(TBSIssueType.UPDATE_ROOT_CERTIFICATE.equals((Object)this.getTBSIssueType()) || TBSIssueType.SEND_CERTIFICATE.equals((Object)this.getTBSIssueType()) || TBSIssueType.SEND_CROSS_CERTIFICATE.equals((Object)this.getTBSIssueType()))) {
            throw new Exception("type error: want -> " + (Object)((Object)TBSIssueType.UPDATE_ROOT_CERTIFICATE) + " or " + (Object)((Object)TBSIssueType.SEND_CERTIFICATE) + " or " + (Object)((Object)TBSIssueType.SEND_CROSS_CERTIFICATE) + " but is -> " + (Object)((Object)this.getTBSIssueType()));
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (Certificate c : cs = this.getTBSIssueRequest().getCert()) {
            X509Certificate cert = X509Utils.convertCertificate(c);
            certificates.add(cert);
        }
        return certificates;
    }

    public List<PkixIssueCRL> getCRLList() throws Exception {
        ASN1CRL[] cls;
        if (!TBSIssueType.SEND_CRL.equals((Object)this.getTBSIssueType())) {
            throw new Exception("type error");
        }
        ArrayList<PkixIssueCRL> list = new ArrayList<PkixIssueCRL>();
        for (ASN1CRL c : cls = this.getTBSIssueRequest().getmCRL()) {
            X509CRL crl = X509Utils.converCRL(c.getCertificateList());
            list.add(new PkixIssueCRL(c.getCRLSegment().getValue().intValue(), crl));
        }
        return list;
    }

    public List<CertStatus> getCertStatusList() throws Exception {
        if (!TBSIssueType.SEND_CERTIFICATE_STATUS.equals((Object)this.getTBSIssueType())) {
            throw new Exception("type error");
        }
        return Arrays.asList(this.getTBSIssueRequest().getCertStatus());
    }
}

