/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.ASN1CRL;
import com.xdja.pki.asn1.issue.CertStatus;
import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.issue.BasicPkixIssueBuilder;
import com.xdja.pki.issue.PkixIssueCRL;
import com.xdja.pki.issue.PkixIssueCertStatus;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueUtils;
import com.xdja.pki.issue.TBSIssueCRLReason;
import com.xdja.pki.issue.TBSIssueCRLStatus;
import com.xdja.pki.issue.TBSIssueType;
import com.xdja.pki.ldap.utils.X509Utils;
import java.io.IOException;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import sun.security.provider.certpath.X509CertificatePair;

public class PkixIssueReqBuilder
extends BasicPkixIssueBuilder {
    private String hashAlgorithm;

    public PkixIssueReqBuilder(KeyPair keyPair, X509Certificate certificate, String hashAlgorithm) {
        super(keyPair, certificate);
        this.hashAlgorithm = hashAlgorithm;
    }

    public PkixIssueReq build(X509Certificate oldWithNew, X509Certificate newWithOld, X509Certificate newWithNew) throws Exception {
        if (X509Utils.verifyCert(newWithOld, this.certificate.getPublicKey()) && X509Utils.verifyCert(oldWithNew, newWithNew.getPublicKey()) && X509Utils.verifyCert(newWithNew, newWithNew.getPublicKey())) {
            this.certificate = newWithNew;
            return this.generate(TBSIssueType.UPDATE_ROOT_CERTIFICATE, new Certificate[]{X509Utils.convertCertificate(oldWithNew), X509Utils.convertCertificate(newWithOld), X509Utils.convertCertificate(newWithNew)}, null, null);
        }
        throw new Exception("verify is false");
    }

    public PkixIssueReq build(X509Certificate cert) throws Exception {
        return this.generate(TBSIssueType.SEND_CERTIFICATE, new Certificate[]{X509Utils.convertCertificate(cert)}, null, null);
    }

    public PkixIssueReq buildSendCerts(List<X509Certificate> certs) throws Exception {
        Certificate[] certificates = new Certificate[certs.size()];
        for (int i = 0; i < certs.size(); ++i) {
            certificates[i] = X509Utils.convertCertificate(certs.get(i));
        }
        return this.generate(TBSIssueType.SEND_CERTIFICATE, certificates, null, null);
    }

    public PkixIssueReq build(int crlSegment, X509CRL crl) throws Exception {
        return this.generate(TBSIssueType.SEND_CRL, null, null, new ASN1CRL[]{this.generateASN1CRL(crlSegment, crl)});
    }

    public PkixIssueReq buildSendCrls(List<PkixIssueCRL> list) throws Exception {
        ASN1CRL[] asn1CRLS = new ASN1CRL[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            asn1CRLS[i] = this.generateASN1CRL(list.get(i).getCrlSegment(), list.get(i).getCrl());
        }
        return this.generate(TBSIssueType.SEND_CRL, null, null, asn1CRLS);
    }

    public PkixIssueReq build(TBSIssueCRLReason reason, X509Certificate certificate) throws Exception {
        return this.generate(TBSIssueType.SEND_CERTIFICATE_STATUS, null, new CertStatus[]{this.generateCertStatus(reason.getType(), certificate)}, null);
    }

    public PkixIssueReq buildSendCertStatuses(List<PkixIssueCertStatus> list) throws Exception {
        CertStatus[] statuses = new CertStatus[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            statuses[i] = this.generateCertStatus(list.get(i).getReason().getType(), list.get(i).getCertificate());
        }
        return this.generate(TBSIssueType.SEND_CERTIFICATE_STATUS, null, statuses, null);
    }

    public PkixIssueReq build(X509CertificatePair pair) throws Exception {
        if (pair.getForward() == null && pair.getReverse() == null) {
            throw new Exception("can not be all null");
        }
        if (pair.getForward() == null) {
            return this.generate(TBSIssueType.SEND_CROSS_CERTIFICATE, new Certificate[]{X509Utils.convertCertificate(pair.getReverse())}, null, null);
        }
        if (pair.getReverse() == null) {
            return this.generate(TBSIssueType.SEND_CROSS_CERTIFICATE, new Certificate[]{X509Utils.convertCertificate(pair.getForward())}, null, null);
        }
        return this.generate(TBSIssueType.SEND_CROSS_CERTIFICATE, new Certificate[]{X509Utils.convertCertificate(pair.getForward()), X509Utils.convertCertificate(pair.getReverse())}, null, null);
    }

    private ASN1CRL generateASN1CRL(int crlSegment, X509CRL crl) throws CRLException, CertificateException, NoSuchProviderException, IOException {
        byte[] bytes;
        ASN1Integer stateOrProvinceNum = new ASN1Integer(0L);
        ASN1Integer crlSegmentASN1 = new ASN1Integer((long)crlSegment);
        ASN1Integer cRLNumber = new ASN1Integer(crl.getExtensionValue(Extension.cRLNumber.getId()));
        ASN1Integer deltareCRLNumber = null;
        if (X509Utils.isDRL(crl) && (bytes = crl.getExtensionValue(Extension.deltaCRLIndicator.getId())) != null) {
            deltareCRLNumber = ASN1Integer.getInstance((Object)DEROctetString.getInstance((Object)bytes).getOctets());
        }
        CertificateList certificateList = CertificateList.getInstance((Object)crl.getEncoded());
        return new ASN1CRL(stateOrProvinceNum, crlSegmentASN1, cRLNumber, deltareCRLNumber, certificateList);
    }

    private CertStatus generateCertStatus(int reason, X509Certificate cert) throws Exception {
        CertificateID certId = new CertificateID(new BcDigestCalculatorProvider().get(new DefaultDigestAlgorithmIdentifierFinder().find(this.hashAlgorithm)), new X509CertificateHolder(this.certificate.getEncoded()), cert.getSerialNumber());
        ASN1GeneralizedTime beforeTime = new ASN1GeneralizedTime(cert.getNotBefore());
        ASN1GeneralizedTime endTime = new ASN1GeneralizedTime(cert.getNotAfter());
        ASN1Integer asn1Status = TBSIssueCRLStatus.INVALID.encode();
        ASN1GeneralizedTime statusTime = new ASN1GeneralizedTime(new Date(System.currentTimeMillis()));
        CRLReason crlReason = CRLReason.lookup((int)reason);
        return new CertStatus(certId.toASN1Primitive(), beforeTime, endTime, asn1Status, statusTime, crlReason);
    }

    private PkixIssueReq generate(TBSIssueType type, Certificate[] cert, CertStatus[] certStatus, ASN1CRL[] mCRL) throws Exception {
        ASN1Integer number;
        ASN1Integer typeASN1 = type.encode();
        ASN1OctetString transNonce = PkixIssueUtils.generateTransNonce();
        ASN1GeneralizedTime time = PkixIssueUtils.generateTime();
        switch (type) {
            case UPDATE_ROOT_CERTIFICATE: 
            case SEND_CERTIFICATE: 
            case SEND_CROSS_CERTIFICATE: {
                number = new ASN1Integer((long)cert.length);
                break;
            }
            case SEND_CRL: {
                number = new ASN1Integer((long)mCRL.length);
                break;
            }
            case SEND_CERTIFICATE_STATUS: {
                number = new ASN1Integer((long)certStatus.length);
                break;
            }
            default: {
                throw new Exception("unknown type " + (Object)((Object)type));
            }
        }
        TBSIssueRequest pkixIssueInfo = new TBSIssueRequest(typeASN1, transNonce, number, time, cert, certStatus, mCRL);
        Signature signature = this.getSignature(pkixIssueInfo);
        return new PkixIssueReq(pkixIssueInfo, signature);
    }
}

