/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ldap.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Set;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jcajce.util.MessageDigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import sun.security.provider.certpath.X509CertificatePair;

public class X509Utils {
    public static boolean isCACertificate(X509Certificate certificate) {
        int basic = certificate.getBasicConstraints();
        System.out.println(certificate.getSubjectDN().getName() + ": basic constraints is " + basic + " is ca " + (basic >= 0));
        return basic >= 0;
    }

    public static boolean isDRL(X509CRL crl) {
        Set<String> critical = crl.getCriticalExtensionOIDs();
        return critical != null && critical.contains(Extension.deltaCRLIndicator.getId());
    }

    public static boolean isARL(X509CRL crl) throws IOException {
        byte[] ext = crl.getExtensionValue(Extension.issuingDistributionPoint.getId());
        if (ext == null) {
            return false;
        }
        ASN1InputStream aIn = new ASN1InputStream(ext);
        ASN1OctetString octs = (ASN1OctetString)aIn.readObject();
        aIn = new ASN1InputStream(octs.getOctets());
        ASN1Primitive idp = aIn.readObject();
        IssuingDistributionPoint p = IssuingDistributionPoint.getInstance((Object)idp);
        return p.onlyContainsCACerts();
    }

    public static Certificate convertCertificate(X509Certificate cert) throws CertificateEncodingException, IOException {
        return Certificate.getInstance((Object)ASN1Primitive.fromByteArray((byte[])cert.getEncoded()));
    }

    public static X509Certificate convertCertificate(Certificate cert) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
    }

    public static X509CRL converCRL(CertificateList certificateList) throws Exception {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        return (X509CRL)certificateFactory.generateCRL(new ByteArrayInputStream(certificateList.getEncoded()));
    }

    public static org.bouncycastle.x509.X509CertificatePair convertCertificatePair(X509CertificatePair pair) throws Exception {
        return new org.bouncycastle.x509.X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static X509CertificatePair convertCertificatePair(org.bouncycastle.x509.X509CertificatePair pair) throws Exception {
        return new X509CertificatePair(pair.getForward(), pair.getReverse());
    }

    public static DERSequence toSequence(ASN1Encodable[] o) {
        if (o != null) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            for (int i = 0; i < o.length; ++i) {
                v.add(o[i]);
            }
            return new DERSequence(v);
        }
        return null;
    }

    public static byte[] messageDigest(byte[] b, ASN1ObjectIdentifier hashAlgorithm) throws NoSuchProviderException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(MessageDigestUtils.getDigestName((ASN1ObjectIdentifier)hashAlgorithm), "BC");
        digest.update(b, 0, b.length);
        return digest.digest();
    }

    public static void writePEM(Object object, Writer writer) throws Exception {
        JcaPEMWriter pw = new JcaPEMWriter(writer);
        pw.writeObject(object);
        pw.flush();
        pw.close();
    }

    public static void printCertificate(X509Certificate certificate) throws Exception {
        StringWriter writer = new StringWriter();
        X509Utils.writePEM(certificate, writer);
        System.out.println(writer.toString());
    }

    public static void writeCertificate(String path, String name, X509Certificate certificate) throws Exception {
        String filename = path + name + ".cer";
        FileOutputStream out = new FileOutputStream(filename);
        out.write(certificate.getEncoded());
        out.close();
        System.out.println(filename + " write cer done!");
        filename = path + name + ".pem";
        FileWriter writer = new FileWriter(filename);
        X509Utils.writePEM(certificate, writer);
        System.out.println(filename + " write pem done!");
    }

    public static void writePrivateKey(String path, String name, KeyPair keyPair) throws Exception {
        String filename = path + name + "_key.pem";
        FileWriter writer = new FileWriter(filename);
        X509Utils.writePEM(keyPair, writer);
        System.out.println(filename + " write key pem done!");
    }

    public static PEMParser getPEMParser(String path) throws Exception {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(path);
        if (inputStream == null) {
            inputStream = new FileInputStream(path);
        }
        InputStreamReader reader = new InputStreamReader(inputStream);
        return new PEMParser((Reader)reader);
    }

    public static KeyPair getKeyPairFromPEM(String path) throws Exception {
        PEMParser pemParser = X509Utils.getPEMParser(path);
        PEMKeyPair pemPair = (PEMKeyPair)pemParser.readObject();
        KeyPair keyPair = new JcaPEMKeyConverter().setProvider("BC").getKeyPair(pemPair);
        return keyPair;
    }

    public static X509Certificate getX509CertificateFromPEM(String path) throws Exception {
        PEMParser pemParser = X509Utils.getPEMParser(path);
        X509CertificateHolder holder = (X509CertificateHolder)pemParser.readObject();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(holder.getEncoded());
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        return certificate;
    }

    public static X509Certificate getX509CertificateFromCer(String path) throws Exception {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(ClassLoader.getSystemResourceAsStream(path));
        return certificate;
    }

    public static boolean verifyCert(X509Certificate cert, PublicKey publicKey) throws Exception {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(publicKey);
        try {
            Certificate certificate = X509Utils.convertCertificate(cert);
            ContentVerifier verifier = verifierProvider.get(certificate.getSignatureAlgorithm());
            OutputStream out = verifier.getOutputStream();
            byte[] encoded = certificate.getTBSCertificate().getEncoded();
            out.write(encoded);
            return verifier.verify(certificate.getSignature().getOctets());
        }
        catch (Exception e) {
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

