package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.x509.CertificateList;

import java.util.Enumeration;

/***
 * CertStatus :: = SEQUENCE {
 *     stateOrProvinceNum   INTEGER,           -- 区域区别号，CRL发布点可以很多，发布内容可以不容，只有唯一地点的为0
 *     CLRSegment           INTEGER,           -- 证书链的块号，为防止证书链太大，一般按证书号分块，同块内的证书在同一条链中
 *     CRLNumber            INTEGER,           -- 证书链的基本序列号
 *     DeltareCRLNumber     INTEGER OPTIONAL,  -- 证书链的增量序列号
 *     CertificateList      SEQUENCE {
 *         tbsCertList TBSCertList,
 *         signatureAlgorithm  AlgorithmIdentifier,
 *         signatureValue  BIT STRING
 *     }
 * }
 *
 */
public class ASN1CRL extends ASN1Object {

    ASN1Integer stateOrProvinceNum;
    ASN1Integer crlSegment;
    ASN1Integer cRLNumber;
    ASN1Integer deltareCRLNumber;
    CertificateList certificateList;

    public static ASN1CRL getInstance(Object o) {
        if (o instanceof ASN1CRL) {
            return (ASN1CRL) o;
        } else if (o != null) {
            return new ASN1CRL(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public ASN1CRL(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        stateOrProvinceNum = ASN1Integer.getInstance(e.nextElement());
        crlSegment = ASN1Integer.getInstance(e.nextElement());
        cRLNumber = ASN1Integer.getInstance(e.nextElement());
        Object o = e.nextElement();
        if (o instanceof ASN1Integer){
            deltareCRLNumber = ASN1Integer.getInstance(o);
            certificateList = CertificateList.getInstance(e.nextElement());
        } else {
            certificateList = CertificateList.getInstance(o);
        }
    }

    public ASN1CRL(ASN1Integer stateOrProvinceNum,
                   ASN1Integer crlSegment,
                   ASN1Integer cRLNumber,
                   ASN1Integer deltareCRLNumber,
                   CertificateList certificateList) {
        super();
        this.stateOrProvinceNum = stateOrProvinceNum;
        this.crlSegment = crlSegment;
        this.cRLNumber = cRLNumber;
        this.deltareCRLNumber = deltareCRLNumber;
        this.certificateList = certificateList;
    }

    public ASN1Integer getStateOrProvinceNum() {
        return stateOrProvinceNum;
    }

    public ASN1Integer getCRLSegment() {
        return crlSegment;
    }

    public ASN1Integer getcRLNumber() {
        return cRLNumber;
    }

    public ASN1Integer getDeltareCRLNumber() {
        return deltareCRLNumber;
    }

    public CertificateList getCertificateList() {
        return certificateList;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(stateOrProvinceNum);
        vector.add(crlSegment);
        vector.add(cRLNumber);
        if (deltareCRLNumber != null){
            vector.add(deltareCRLNumber);
        }
        vector.add(certificateList);
        return new DERSequence(vector);
    }
}
