package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PkixIssue extends ASN1Object {

    TBSIssue tbsIssue;
    AlgorithmIdentifier signatureAlgorithm;
    Signature signature;

    public PkixIssue(TBSIssue tbsIssue, AlgorithmIdentifier signatureAlgorithm, Signature signature) {
        this.tbsIssue = tbsIssue;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signature = signature;
    }

    public TBSIssue getTBSIssue() {
        return this.tbsIssue;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public byte[] getSignatureInfo() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.tbsIssue.getEncoded(ASN1Encoding.DER));
        output.write(this.signatureAlgorithm.getEncoded(ASN1Encoding.DER));
        return output.toByteArray();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.tbsIssue);
        vector.add(this.signatureAlgorithm);
        vector.add(this.signature);
        return new DERSequence(vector);
    }
}