package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PkixIssueRequest extends PkixIssue {

    public static PkixIssueRequest getInstance(Object o) {
        if (o instanceof PkixIssueRequest) {
            return (PkixIssueRequest) o;
        } else if (o != null) {
            return new PkixIssueRequest(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public PkixIssueRequest(ASN1Sequence asn1Sequence) {
        super (
                TBSIssueRequest.getInstance(asn1Sequence.getObjectAt(0)),
                AlgorithmIdentifier.getInstance(asn1Sequence.getObjectAt(1)),
                Signature.getInstance(asn1Sequence.getObjectAt(2))
        );
    }

    public PkixIssueRequest(TBSIssueRequest tbsIssue, AlgorithmIdentifier signatureAlgorithm, Signature signature) {
        super(tbsIssue, signatureAlgorithm, signature);
    }
}
