package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.*;

/***
 * TBSIssueResponse :: = SEQUENCE {
 *     version          Version,               -- 版本号，目前为1
 *     type             INTEGER,               -- 类型
 *                                                  0：向 LDAP 或 OCSP 更新根证书
 *                                                  1：向 LDAP 发送证书
 *                                                  2：向 LDAP 发送作废证书序列号
 *                                                  3：向 LDAP 发送作废证书链
 *                                                  4：向 OCSP 发送证书状态
 *                                                  8：向 LDAP 发送交叉认证证书，LDAP 自己用根证书与此包中的第一个证书组成 PKCS#7 证书发布链
 *     transNonce       OCTET STRING OPTIONAL,  -- 包内随机数
 *     number           INTEGER OPTIONAL,       -- 包内证书或证书状态或证书撤销链数目
 *     time             GeneralizedTime,        -- 接收方时间
 *     responseStatus   INTEGER,                -- 0 为正常接收，1 为未接收请下次重发
 * }
 *
 */
public class TBSIssueResponse extends TBSIssue {

    ASN1Integer responseStatus;

    public static TBSIssueResponse getInstance(Object o) {
        if (o instanceof TBSIssueResponse) {
            return (TBSIssueResponse) o;
        } else if (o != null) {
            return new TBSIssueResponse(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public TBSIssueResponse(ASN1Sequence asn1Sequence) {
        super(asn1Sequence);
        responseStatus = ASN1Integer.getInstance(this.enumeration.nextElement());
    }

    public TBSIssueResponse(ASN1Integer type, ASN1OctetString transNonce, ASN1Integer number, ASN1GeneralizedTime time, ASN1Integer responseStatus) {
        super(type, transNonce, number, time);
        this.responseStatus = responseStatus;
    }

    public ASN1Integer getResponseStatus() {
        return responseStatus;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = this.getVector();
        vector.add(this.responseStatus);
        return new DERSequence(vector);
    }
}
