package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssue;
import com.xdja.pki.gmssl.core.utils.GMSSLByteArrayUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.ldap.X509Utils;
import org.bouncycastle.asn1.ASN1Encoding;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.KeyPair;
import java.security.cert.X509Certificate;

public class BasicPkixIssueBuilder {
    private Logger logger = LoggerFactory.getLogger(BasicPkixIssue.class);
    protected KeyPair keyPair;
    protected X509Certificate certificate;
    protected int privateKeyIndex;
    protected String privateKeyPassword;
    protected SdfCryptoType sdfCryptoType;
    protected boolean isSignByBC;

    public BasicPkixIssueBuilder(KeyPair keyPair, X509Certificate certificate) {
        this.keyPair = keyPair;
        this.certificate = certificate;
        this.isSignByBC = true;
    }

    public BasicPkixIssueBuilder(int privateKeyIndex, String privateKeyPassword, X509Certificate certificate, SdfCryptoType sdfCryptoType) {
        this.privateKeyIndex = privateKeyIndex;
        this.privateKeyPassword = privateKeyPassword;
        this.certificate = certificate;
        this.sdfCryptoType = sdfCryptoType;
        this.isSignByBC = false;
    }

    // TODO: 2019/3/11 签名算法从证书中读取
    protected Signature getSignature(TBSIssue tbsIssue) throws Exception {
        if (this.isSignByBC) {
            return getSignatureByBC(tbsIssue);
        } else {
            return getSignatureBySdf(tbsIssue);
        }
    }

    // TODO: 2019/3/11 签名算法从证书中读取
    protected Signature getSignatureByBC(TBSIssue tbsIssue) throws Exception {
        logger.debug(" getSignatureByBC    certificate.getSigAlgOID()" + certificate.getSigAlgOID());
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
        byte[] data = tbsIssue.getEncoded(ASN1Encoding.DER);
        byte[] signByBC = GMSSLSM2SignUtils.signByBC(keyPair.getPrivate(), data);
        return new Signature(signatureAlgorithm, new DERBitString(signByBC), X509Utils.toSequence(new Certificate[]{X509Utils.convertCertificate(certificate)}));
    }

    // TODO: 2019/3/11 签名算法从证书中读取
    protected Signature getSignatureBySdf(TBSIssue tbsIssue) throws Exception {
        logger.debug(" getSignatureBySdf    " + this.sdfCryptoType.name());
        AlgorithmIdentifier signatureAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
        byte[] data = tbsIssue.getEncoded(ASN1Encoding.DER);
        byte[] signBySdf = GMSSLSM2SignUtils.signBySdf(sdfCryptoType, privateKeyIndex, privateKeyPassword, data);
        return new Signature(signatureAlgorithm, new DERBitString(signBySdf), X509Utils.toSequence(new Certificate[]{X509Utils.convertCertificate(certificate)}));
    }
}
