package com.xdja.pki.issue;


import org.bouncycastle.asn1.ASN1Integer;


public enum TBSIssueCRLReason {
    Unspecified(0),
    KeyCompromise(1),
    CACompromise(2),
    AffiliationChanged(3),
    Superseded(4),
    CessationOfOperation(5),
    CertificateHold(6),
    RemoveFromCRL(8),
    PrivilegeWithdrawn(9),
    AACompromise(10);


    private int type;

    TBSIssueCRLReason(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public ASN1Integer encode() {
        return new ASN1Integer(type);
    }

    public static TBSIssueCRLReason decode(ASN1Integer t) throws Exception {
        switch (t.getValue().intValue()) {
            case 0:
                return Unspecified;
            case 1:
                return KeyCompromise;
            case 2:
                return CACompromise;
            case 3:
                return AffiliationChanged;
            case 4:
                return Superseded;
            case 5:
                return CessationOfOperation;
            case 6:
                return CertificateHold;
            case 8:
                return RemoveFromCRL;
            case 9:
                return PrivilegeWithdrawn;
            case 10:
                return AACompromise;
            default:
                throw new Exception("unknown type");
        }
    }
}
