package com.xdja.pki.issue;

import org.bouncycastle.asn1.ASN1Integer;

public enum TBSIssueResponseStatus {

    Normal(0),
    Error(1);

    private int type;

    TBSIssueResponseStatus(int type) {
        this.type = type;
    }

    public int getType() {
        return type;
    }

    public ASN1Integer encode() {
        return new ASN1Integer(type);
    }

    public static TBSIssueResponseStatus decode(ASN1Integer t) throws Exception {
        switch (t.getValue().intValue()) {
            case 0:
                return Normal;
            case 1:
                return Error;
            default:
                throw new Exception("unknown type");
        }
    }
}
