/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.asn1.issue;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.CertificateList;

public class ASN1CRL
extends ASN1Object {
    ASN1Integer stateOrProvinceNum;
    ASN1Integer crlSegment;
    ASN1Integer cRLNumber;
    ASN1Integer deltareCRLNumber;
    CertificateList certificateList;

    public static ASN1CRL getInstance(Object o) {
        if (o instanceof ASN1CRL) {
            return (ASN1CRL)((Object)o);
        }
        if (o != null) {
            return new ASN1CRL(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public ASN1CRL(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        this.stateOrProvinceNum = ASN1Integer.getInstance(e.nextElement());
        this.crlSegment = ASN1Integer.getInstance(e.nextElement());
        this.cRLNumber = ASN1Integer.getInstance(e.nextElement());
        Object o = e.nextElement();
        if (o instanceof ASN1Integer) {
            this.deltareCRLNumber = ASN1Integer.getInstance(o);
            this.certificateList = CertificateList.getInstance(e.nextElement());
        } else {
            this.certificateList = CertificateList.getInstance(o);
        }
    }

    public ASN1CRL(ASN1Integer stateOrProvinceNum, ASN1Integer crlSegment, ASN1Integer cRLNumber, ASN1Integer deltareCRLNumber, CertificateList certificateList) {
        this.stateOrProvinceNum = stateOrProvinceNum;
        this.crlSegment = crlSegment;
        this.cRLNumber = cRLNumber;
        this.deltareCRLNumber = deltareCRLNumber;
        this.certificateList = certificateList;
    }

    public ASN1Integer getStateOrProvinceNum() {
        return this.stateOrProvinceNum;
    }

    public ASN1Integer getCRLSegment() {
        return this.crlSegment;
    }

    public ASN1Integer getcRLNumber() {
        return this.cRLNumber;
    }

    public ASN1Integer getDeltareCRLNumber() {
        return this.deltareCRLNumber;
    }

    public CertificateList getCertificateList() {
        return this.certificateList;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.stateOrProvinceNum);
        vector.add((ASN1Encodable)this.crlSegment);
        vector.add((ASN1Encodable)this.cRLNumber);
        if (this.deltareCRLNumber != null) {
            vector.add((ASN1Encodable)this.deltareCRLNumber);
        }
        vector.add((ASN1Encodable)this.certificateList);
        return new DERSequence(vector);
    }
}

