/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssueResponse;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.issue.BasicPkixIssueBuilder;
import com.xdja.pki.issue.PkixIssueReq;
import com.xdja.pki.issue.PkixIssueResp;
import com.xdja.pki.issue.PkixIssueUtils;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ocsp.Signature;

public class PkixIssueRespBuilder
extends BasicPkixIssueBuilder {
    public PkixIssueRespBuilder(KeyPair keyPair, List<X509Certificate> caCerts) {
        super(keyPair, caCerts);
    }

    public PkixIssueRespBuilder(int privateKeyIndex, String privateKeyPassword, List<X509Certificate> caCerts, SdfCryptoType sdfCryptoType) {
        super(privateKeyIndex, privateKeyPassword, caCerts, sdfCryptoType);
    }

    public PkixIssueResp build(PkixIssueReq req, TBSIssueResponseStatus status, String signAlgName) throws Exception {
        ASN1Integer typeASN1 = req.getPkixIssue().getTBSIssue().getType();
        ASN1OctetString transNonce = req.getPkixIssue().getTBSIssue().getTransNonce();
        ASN1Integer number = req.getPkixIssue().getTBSIssue().getNumber();
        return this.build(typeASN1, transNonce, number, status, signAlgName);
    }

    public PkixIssueResp build(ASN1Integer typeASN1, ASN1OctetString transNonce, ASN1Integer number, TBSIssueResponseStatus responseStatus, String signAlgName) throws Exception {
        ASN1GeneralizedTime time = PkixIssueUtils.generateTime();
        TBSIssueResponse tbsIssueResponse = new TBSIssueResponse(typeASN1, transNonce, number, time, responseStatus.encode());
        Signature responseSignature = this.getSignature(tbsIssueResponse, signAlgName);
        return new PkixIssueResp(tbsIssueResponse, responseSignature);
    }
}

