/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.PkixIssue;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.issue.TBSIssueType;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.operator.ContentVerifier;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPkixIssue {
    protected PkixIssue issue;
    private Logger logger = LoggerFactory.getLogger(BasicPkixIssue.class);

    BasicPkixIssue() {
    }

    boolean isSigned() {
        return this.issue.getSignature() != null;
    }

    public ASN1ObjectIdentifier getSignatureAlgOID() {
        if (!this.isSigned()) {
            return null;
        }
        return this.issue.getSignature().getSignatureAlgorithm().getAlgorithm();
    }

    public PkixIssue getPkixIssue() {
        return this.issue;
    }

    public TBSIssueType getTBSIssueType() throws Exception {
        return TBSIssueType.decode(this.issue.getTBSIssue().getType());
    }

    public byte[] getSignatureValues() {
        if (!this.isSigned()) {
            return null;
        }
        return this.issue.getSignature().getSignature().getOctets();
    }

    public boolean isSignatureValid(ContentVerifierProvider verifierProvider) throws Exception {
        if (!this.isSigned()) {
            this.logger.error("\u8be5\u7ed3\u6784\u4f53\u6ca1\u6709\u88ab\u7b7e\u540d");
            throw new Exception("attempt to verify signature on unsigned object");
        }
        try {
            ContentVerifier verifier = verifierProvider.get(this.issue.getSignature().getSignatureAlgorithm());
            OutputStream out = verifier.getOutputStream();
            out.write(this.issue.getSignatureInfo());
            return verifier.verify(this.getSignatureValues());
        }
        catch (Exception e) {
            this.logger.error("\u7ed3\u6784\u4f53\u9a8c\u7b7e\u5931\u8d25");
            throw new Exception("exception processing signature: " + e, e);
        }
    }

    public boolean isSignatureValid(KeyPair keyPair) throws Exception {
        return this.isSignatureValid(keyPair.getPublic());
    }

    public boolean isSignatureValid(PublicKey key) throws Exception {
        ContentVerifierProvider verifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(key);
        return this.isSignatureValid(verifierProvider);
    }

    public boolean verifySignatureByBC(List<X509Certificate> issueCerts, String sigAlgName) throws Exception {
        for (int i = 0; i < issueCerts.size(); ++i) {
            boolean flag = this.verifySignatureByBC(issueCerts.get(i).getPublicKey(), sigAlgName);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public boolean verifySignatureBySdf(List<X509Certificate> certificates, SdfCryptoType sdfCryptoType) throws Exception {
        for (int i = 0; i < certificates.size(); ++i) {
            boolean flag = this.verifySignatureBySdf(certificates.get(i).getPublicKey(), certificates.get(i).getSigAlgName(), sdfCryptoType);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public boolean verifySignatureBySdf(PublicKey key, String sigAlgName, SdfCryptoType sdfCryptoType) throws Exception {
        if (!this.isSigned()) {
            this.logger.error("\u8be5\u7ed3\u6784\u4f53\u6ca1\u6709\u88ab\u7b7e\u540d");
            throw new Exception("attempt to verify signature on unsigned object");
        }
        this.logger.debug("\u901a\u8fc7" + sdfCryptoType.name() + "\u8fdb\u884c\u9a8c\u7b7e");
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            return GMSSLSM2SignUtils.verifyBySdf((SdfCryptoType)sdfCryptoType, (PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues());
        }
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName()) || sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName())) {
            return GMSSLRSASignUtils.verifyByYunHsm((String)sigAlgName, (PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues());
        }
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())) {
            return GMSSLECSignUtils.verifyByYunHsm((PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues(), (String)sigAlgName);
        }
        this.logger.error("\u6682\u672a\u672a\u627e\u5230" + sigAlgName + "\u7c7b\u578b\u9a8c\u7b7e\u65b9\u5f0f");
        throw new Exception("can't get verify sign with " + sigAlgName + " type");
    }

    public boolean verifySignatureByBC(PublicKey key, String sigAlgName) throws Exception {
        if (!this.isSigned()) {
            this.logger.error("\u8be5\u7ed3\u6784\u4f53\u6ca1\u6709\u88ab\u7b7e\u540d");
            throw new Exception("attempt to verify signature on unsigned object");
        }
        this.logger.debug("\u901a\u8fc7BC\u8fdb\u884c\u9a8c\u7b7e");
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            return GMSSLSM2SignUtils.verifyByBC((PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues());
        }
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName()) || sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName())) {
            return GMSSLRSASignUtils.verifyByBC((String)sigAlgName, (PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues());
        }
        if (sigAlgName.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())) {
            return GMSSLBCSignUtils.verifySignature((String)sigAlgName, (PublicKey)key, (byte[])this.issue.getTBSIssue().getEncoded("DER"), (byte[])this.getSignatureValues());
        }
        this.logger.error("\u6682\u672a\u672a\u627e\u5230" + sigAlgName + "\u7c7b\u578b\u9a8c\u7b7e\u65b9\u5f0f");
        throw new Exception("can't get verify sign with " + sigAlgName + " type");
    }

    public byte[] getEncoded() throws IOException {
        return this.issue.getEncoded();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPkixIssue that = (BasicPkixIssue)o;
        return Objects.equals((Object)this.issue, (Object)that.issue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.issue});
    }
}

