/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.asn1.issue;

import com.xdja.pki.asn1.issue.TBSIssue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PkixIssue
extends ASN1Object {
    TBSIssue tbsIssue;
    AlgorithmIdentifier signatureAlgorithm;
    Signature signature;

    public PkixIssue(TBSIssue tbsIssue, AlgorithmIdentifier signatureAlgorithm, Signature signature) {
        this.tbsIssue = tbsIssue;
        this.signatureAlgorithm = signatureAlgorithm;
        this.signature = signature;
    }

    public TBSIssue getTBSIssue() {
        return this.tbsIssue;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public byte[] getSignatureInfo() throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.tbsIssue.getEncoded("DER"));
        output.write(this.signatureAlgorithm.getEncoded("DER"));
        return output.toByteArray();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.tbsIssue);
        vector.add((ASN1Encodable)this.signatureAlgorithm);
        vector.add((ASN1Encodable)this.signature);
        return new DERSequence(vector);
    }
}

