/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.asn1.issue;

import com.xdja.pki.asn1.issue.ASN1CRL;
import com.xdja.pki.asn1.issue.CertStatus;
import com.xdja.pki.asn1.issue.TBSIssue;
import com.xdja.pki.ldap.X509Utils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.Certificate;

public class TBSIssueRequest
extends TBSIssue {
    ASN1Sequence cert;
    ASN1Sequence certStatus;
    ASN1Sequence mCRL;

    public static TBSIssueRequest getInstance(Object o) {
        if (o instanceof TBSIssueRequest) {
            return (TBSIssueRequest)((Object)o);
        }
        if (o != null) {
            return new TBSIssueRequest(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public TBSIssueRequest(ASN1Sequence asn1Sequence) {
        super(asn1Sequence);
        while (this.enumeration.hasMoreElements()) {
            ASN1TaggedObject tObj = (ASN1TaggedObject)this.enumeration.nextElement();
            switch (tObj.getTagNo()) {
                case 0: {
                    this.cert = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    break;
                }
                case 1: {
                    this.certStatus = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    break;
                }
                case 2: {
                    this.mCRL = ASN1Sequence.getInstance((ASN1TaggedObject)tObj, (boolean)true);
                    break;
                }
            }
        }
    }

    public TBSIssueRequest(ASN1Integer type, ASN1OctetString transNonce, ASN1Integer number, ASN1GeneralizedTime time, Certificate[] cert, CertStatus[] certStatus, ASN1CRL[] mCRL) {
        super(type, transNonce, number, time);
        this.cert = X509Utils.toSequence((ASN1Encodable[])cert);
        this.certStatus = X509Utils.toSequence((ASN1Encodable[])certStatus);
        this.mCRL = X509Utils.toSequence((ASN1Encodable[])mCRL);
    }

    public Certificate[] getCert() {
        if (this.cert == null) {
            return null;
        }
        Certificate[] results = new Certificate[this.cert.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = Certificate.getInstance((Object)this.cert.getObjectAt(i));
        }
        return results;
    }

    public CertStatus[] getCertStatus() {
        if (this.certStatus == null) {
            return null;
        }
        CertStatus[] results = new CertStatus[this.certStatus.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = CertStatus.getInstance(this.certStatus.getObjectAt(i));
        }
        return results;
    }

    public ASN1CRL[] getmCRL() {
        if (this.mCRL == null) {
            return null;
        }
        ASN1CRL[] results = new ASN1CRL[this.mCRL.size()];
        for (int i = 0; i < results.length; ++i) {
            results[i] = ASN1CRL.getInstance(this.mCRL.getObjectAt(i));
        }
        return results;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = this.getVector();
        this.addOptional(vector, 0, (ASN1Encodable)this.cert);
        this.addOptional(vector, 1, (ASN1Encodable)this.certStatus);
        this.addOptional(vector, 2, (ASN1Encodable)this.mCRL);
        return new DERSequence(vector);
    }

    private void addOptional(ASN1EncodableVector v, int tagNo, ASN1Encodable obj) {
        if (obj != null) {
            v.add((ASN1Encodable)new DERTaggedObject(true, tagNo, obj));
        }
    }
}

