/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.TBSIssue;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.pki.issue.BasicPkixIssue;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.gm.GMObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicPkixIssueBuilder {
    private Logger logger = LoggerFactory.getLogger(BasicPkixIssue.class);
    protected KeyPair keyPair;
    protected List<X509Certificate> caCerts;
    protected int privateKeyIndex;
    protected String privateKeyPassword;
    protected SdfCryptoType sdfCryptoType;
    protected boolean isSignByBC;

    public BasicPkixIssueBuilder(KeyPair keyPair, List<X509Certificate> caCerts) {
        this.keyPair = keyPair;
        this.caCerts = caCerts;
        this.isSignByBC = true;
    }

    public BasicPkixIssueBuilder(int privateKeyIndex, String privateKeyPassword, List<X509Certificate> caCerts, SdfCryptoType sdfCryptoType) {
        this.privateKeyIndex = privateKeyIndex;
        this.privateKeyPassword = privateKeyPassword;
        this.caCerts = caCerts;
        this.sdfCryptoType = sdfCryptoType;
        this.isSignByBC = false;
    }

    protected Signature getSignature(TBSIssue tbsIssue, String signAlgorithm) throws Exception {
        if (this.isSignByBC) {
            return this.getSignatureByBC(tbsIssue, signAlgorithm);
        }
        return this.getSignatureBySdf(tbsIssue, signAlgorithm);
    }

    protected Signature getSignatureByBC(TBSIssue tbsIssue, String signAlgorithm) throws Exception {
        this.logger.debug(" getSignatureByBC");
        AlgorithmIdentifier signatureAlgorithm = this.getSignatureWithString(signAlgorithm);
        byte[] data = tbsIssue.getEncoded("DER");
        byte[] signByBC = signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName()) ? GMSSLSM2SignUtils.signByBC((PrivateKey)this.keyPair.getPrivate(), (byte[])data) : (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName()) ? GMSSLBCSignUtils.generateSignature((String)signAlgorithm, (PrivateKey)this.keyPair.getPrivate(), (byte[])data) : GMSSLRSASignUtils.signByBC((String)signAlgorithm, (PrivateKey)this.keyPair.getPrivate(), (byte[])data));
        return new Signature(signatureAlgorithm, new DERBitString(signByBC));
    }

    protected Signature getSignatureBySdf(TBSIssue tbsIssue, String signAlgorithm) throws Exception {
        byte[] signBySdf;
        this.logger.debug(" getSignatureBySdf {}", (Object)this.sdfCryptoType.name());
        AlgorithmIdentifier signatureAlgorithm = this.getSignatureWithString(signAlgorithm);
        byte[] data = tbsIssue.getEncoded("DER");
        this.logger.info("get SignAlg is {}", (Object)signAlgorithm);
        if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            this.logger.info("choice sm2");
            signBySdf = GMSSLSM2SignUtils.signBySdf((SdfCryptoType)this.sdfCryptoType, (int)this.privateKeyIndex, (String)this.privateKeyPassword, (byte[])data);
        } else if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())) {
            this.logger.info("choice nist");
            signBySdf = GMSSLECSignUtils.signByYunHsm((int)this.privateKeyIndex, (String)this.privateKeyPassword, (byte[])data, (String)signAlgorithm);
        } else {
            this.logger.info("choice rsa");
            signBySdf = GMSSLRSASignUtils.signByYunHsm((String)signAlgorithm, (int)this.privateKeyIndex, (String)this.privateKeyPassword, (byte[])data);
        }
        return new Signature(signatureAlgorithm, new DERBitString(signBySdf));
    }

    private AlgorithmIdentifier getSignatureWithString(String signAlgorithm) throws Exception {
        AlgorithmIdentifier signatureAlgorithm;
        if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName())) {
            signatureAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption);
        } else if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName())) {
            signatureAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption);
        } else if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SM3_WITH_SM2.getSigAlgName())) {
            signatureAlgorithm = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3);
        } else if (signAlgorithm.equalsIgnoreCase(GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName())) {
            signatureAlgorithm = new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA256);
        } else {
            throw new Exception("can sign with " + signAlgorithm + " type");
        }
        return signatureAlgorithm;
    }
}

