/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import org.bouncycastle.asn1.ASN1Integer;

public enum TBSIssueType {
    UPDATE_ROOT_CERTIFICATE(0),
    SEND_CERTIFICATE(1),
    SEND_CRL(3),
    SEND_CERTIFICATE_STATUS(4),
    SEND_CROSS_CERTIFICATE(8);

    private int type;

    private TBSIssueType(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public ASN1Integer encode() {
        return new ASN1Integer((long)this.type);
    }

    public static TBSIssueType decode(ASN1Integer t) throws Exception {
        switch (t.getValue().intValue()) {
            case 0: {
                return UPDATE_ROOT_CERTIFICATE;
            }
            case 1: {
                return SEND_CERTIFICATE;
            }
            case 3: {
                return SEND_CRL;
            }
            case 4: {
                return SEND_CERTIFICATE_STATUS;
            }
            case 8: {
                return SEND_CROSS_CERTIFICATE;
            }
        }
        throw new Exception("unknown type");
    }
}

