package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.*;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.CRLReason;

import java.util.Enumeration;

/***
 * CertStatus :: = SEQUENCE {
 *     certId           CertID，
 *     BeforeTime       GeneralizedTime,
 *     EndTime          GeneralizedTime,
 *     status           INTEGER, -- 0 有效，1 无效，无效时有原因项
 *     statusTime       GeneralizedTime,
 *     statusReasonRode CRLReason OPTIONAL
 * }
 *
 */
public class CertStatus extends ASN1Object {

    CertID certId;
    ASN1GeneralizedTime beforeTime;
    ASN1GeneralizedTime endTime;
    ASN1Integer status;
    ASN1GeneralizedTime statusTime;
    CRLReason statusReasonRode;


    public static CertStatus getInstance(Object o) {
        if (o instanceof CertStatus) {
            return (CertStatus) o;
        } else if (o != null) {
            return new CertStatus(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public CertStatus(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        certId = CertID.getInstance(e.nextElement());
        beforeTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        endTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        status = ASN1Integer.getInstance(e.nextElement());
        statusTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        statusReasonRode = CRLReason.getInstance(e.nextElement());
    }

    public CertStatus(
            CertID certId,
            ASN1GeneralizedTime beforeTime,
            ASN1GeneralizedTime endTime,
            ASN1Integer status,
            ASN1GeneralizedTime statusTime,
            CRLReason statusReasonRode
    ) {
        super();
        this.certId = certId;
        this.beforeTime = beforeTime;
        this.endTime = endTime;
        this.status = status;
        this.statusTime = statusTime;
        this.statusReasonRode = statusReasonRode;
    }

    public CertID getCertId() {
        return certId;
    }

    public ASN1GeneralizedTime getBeforeTime() {
        return beforeTime;
    }

    public ASN1GeneralizedTime getEndTime() {
        return endTime;
    }

    public ASN1Integer getStatus() {
        return status;
    }

    public ASN1GeneralizedTime getStatusTime() {
        return statusTime;
    }

    public CRLReason getStatusReasonRode() {
        return statusReasonRode;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(certId);
        vector.add(beforeTime);
        vector.add(endTime);
        vector.add(status);
        vector.add(statusTime);
        if (statusReasonRode != null){
            vector.add(statusReasonRode);
        }
        return new DERSequence(vector);
    }
}
