package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.Signature;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class PkixIssueResponse extends PkixIssue {

    public static PkixIssueResponse getInstance(Object o) {
        if (o instanceof PkixIssueResponse) {
            return (PkixIssueResponse) o;
        } else if (o != null) {
            return new PkixIssueResponse(ASN1Sequence.getInstance(o));
        }

        return null;
    }

    public PkixIssueResponse(ASN1Sequence asn1Sequence) {
        super(
                TBSIssueResponse.getInstance(asn1Sequence.getObjectAt(0)),
                AlgorithmIdentifier.getInstance(asn1Sequence.getObjectAt(1)),
                Signature.getInstance(asn1Sequence.getObjectAt(2))
        );
    }

    public PkixIssueResponse(TBSIssueResponse tbsIssue, AlgorithmIdentifier signatureAlgorithm, Signature signature) {
        super(tbsIssue, signatureAlgorithm, signature);
    }
}
