package com.xdja.pki.asn1.issue;

import org.bouncycastle.asn1.*;

import java.util.Enumeration;

public abstract class TBSIssue extends ASN1Object {
    protected static final ASN1Integer V1 = new ASN1Integer(0);

    ASN1Integer version;
    ASN1Integer type;
    ASN1OctetString transNonce;
    ASN1Integer number;
    ASN1GeneralizedTime time;

    protected Enumeration enumeration;

    public TBSIssue(ASN1Sequence asn1Sequence) {
        this.enumeration = asn1Sequence.getObjects();
        this.enumeration.nextElement();
        this.version = V1;
        this.type = ASN1Integer.getInstance(this.enumeration.nextElement());
        this.transNonce = ASN1OctetString.getInstance(this.enumeration.nextElement());
        this.number = ASN1Integer.getInstance(this.enumeration.nextElement());
        this.time = ASN1GeneralizedTime.getInstance(this.enumeration.nextElement());
    }

    public TBSIssue(ASN1Integer type, ASN1OctetString transNonce, ASN1Integer number, ASN1GeneralizedTime time) {
        this.version = V1;
        this.type = type;
        this.transNonce = transNonce;
        this.number = number;
        this.time = time;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getType() {
        return this.type;
    }

    public ASN1OctetString getTransNonce() {
        return this.transNonce;
    }

    public ASN1Integer getNumber() {
        return this.number;
    }

    public ASN1GeneralizedTime getTime() {
        return this.time;
    }

    public ASN1EncodableVector getVector(){
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add(this.version);
        vector.add(this.type);
        if (this.transNonce != null){
            vector.add(this.transNonce);
        }
        if (this.number != null){
            vector.add(this.number);
        }
        vector.add(this.time);
        return vector;
    }
}
