package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.PkixIssueResponse;
import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueResponse;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class PkixIssueResp extends BasicPkixIssue {

    private static Logger logger = LoggerFactory.getLogger(PkixIssueResp.class);

    public PkixIssueResp(byte[] response) throws IOException {
        this(new ASN1InputStream(response));
    }

    private PkixIssueResp(ASN1InputStream inputStream) throws IOException {
        this.issue = PkixIssueResponse.getInstance(inputStream.readObject());
    }

    PkixIssueResp(TBSIssueResponse tbsIssueResponse, Signature signature) {
        // PkixIssue(TBSIssueRequest pkixIssueInfo, AlgorithmIdentifier signatureAlgorithm, Signature caSignature)
        this.issue = new PkixIssueResponse(tbsIssueResponse, signature.getSignatureAlgorithm(), signature);
    }

    public TBSIssueResponseStatus getStatus() throws Exception {
        TBSIssueResponse tbsIssueResponse = (TBSIssueResponse) this.issue.getTBSIssue();
        return TBSIssueResponseStatus.decode(tbsIssueResponse.getResponseStatus());
    }

    //验证time
    public static boolean verifyTime(TBSIssueResponse respIssue, int time) throws ParseException {
        Long nowTime = System.currentTimeMillis();
        Long getTime = respIssue.getTime().getDate().getTime();
        if (nowTime - getTime >= 1000 * time) {
            logger.error("now time " + new Date(nowTime).toString());
            logger.error("get time " + new Date(getTime).toString());
            logger.error("verify time error nowTime = " + nowTime + " getTime = " + getTime + " SUB = " + (nowTime - getTime));
            return false;
        }
        return true;
    }

    //验证transNonce
    public static boolean verifyTranNonce(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getTransNonce().equals(respIssue.getTransNonce())) {
            return true;
        }
        logger.error("req transNonce" + reqIssue.getTransNonce().toString());
        logger.error("resp transNonce" + respIssue.getTransNonce().toString());
        return false;
    }

    //验证number是否相等
    public static boolean verifyNumber(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getNumber().equals(respIssue.getNumber())) {
            return true;
        }
        logger.error("req Number" + reqIssue.getNumber().toString());
        logger.error("resp Number" + respIssue.getNumber().toString());
        return false;
    }

    //验证type是否相等
    public static boolean verifyType(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getType().equals(respIssue.getType())) {
            return true;
        }
        logger.error("req type" + reqIssue.getType().toString());
        logger.error("resp type" + respIssue.getType().toString());
        return false;
    }

    //验证签名
    public static boolean verifySign(PkixIssueResp resp, boolean isOCSPRes, List<X509Certificate> ocspSignCerts,
                                     List<X509Certificate> ldapSignCerts, boolean isSignByBC, SdfCryptoType sdfCryptoType) throws Exception {
        List<X509Certificate> certificates;
        if (isOCSPRes) {
            logger.debug("使用OCSP服务器证书验签 ");
            certificates = ocspSignCerts;
        } else {
            logger.debug("使用LDAP服务器证书验签 ");
            certificates = ldapSignCerts;
        }
        if (isSignByBC) {
            return resp.verifySignatureByBC(certificates, certificates.get(0).getSigAlgName());
        } else {
            return resp.verifySignatureBySdf(certificates, sdfCryptoType);
        }
    }
}
