/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.asn1.issue;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.CRLReason;

public class CertStatus
extends ASN1Object {
    CertID certId;
    ASN1GeneralizedTime beforeTime;
    ASN1GeneralizedTime endTime;
    ASN1Integer status;
    ASN1GeneralizedTime statusTime;
    CRLReason statusReasonRode;

    public static CertStatus getInstance(Object o) {
        if (o instanceof CertStatus) {
            return (CertStatus)((Object)o);
        }
        if (o != null) {
            return new CertStatus(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public CertStatus(ASN1Sequence asn1Sequence) {
        Enumeration e = asn1Sequence.getObjects();
        this.certId = CertID.getInstance(e.nextElement());
        this.beforeTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        this.endTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        this.status = ASN1Integer.getInstance(e.nextElement());
        this.statusTime = ASN1GeneralizedTime.getInstance(e.nextElement());
        this.statusReasonRode = CRLReason.getInstance(e.nextElement());
    }

    public CertStatus(CertID certId, ASN1GeneralizedTime beforeTime, ASN1GeneralizedTime endTime, ASN1Integer status, ASN1GeneralizedTime statusTime, CRLReason statusReasonRode) {
        this.certId = certId;
        this.beforeTime = beforeTime;
        this.endTime = endTime;
        this.status = status;
        this.statusTime = statusTime;
        this.statusReasonRode = statusReasonRode;
    }

    public CertID getCertId() {
        return this.certId;
    }

    public ASN1GeneralizedTime getBeforeTime() {
        return this.beforeTime;
    }

    public ASN1GeneralizedTime getEndTime() {
        return this.endTime;
    }

    public ASN1Integer getStatus() {
        return this.status;
    }

    public ASN1GeneralizedTime getStatusTime() {
        return this.statusTime;
    }

    public CRLReason getStatusReasonRode() {
        return this.statusReasonRode;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.certId);
        vector.add((ASN1Encodable)this.beforeTime);
        vector.add((ASN1Encodable)this.endTime);
        vector.add((ASN1Encodable)this.status);
        vector.add((ASN1Encodable)this.statusTime);
        if (this.statusReasonRode != null) {
            vector.add((ASN1Encodable)this.statusReasonRode);
        }
        return new DERSequence(vector);
    }
}

