/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.asn1.issue;

import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;

public abstract class TBSIssue
extends ASN1Object {
    protected static final ASN1Integer V1 = new ASN1Integer(0L);
    ASN1Integer version;
    ASN1Integer type;
    ASN1OctetString transNonce;
    ASN1Integer number;
    ASN1GeneralizedTime time;
    protected Enumeration enumeration;

    public TBSIssue(ASN1Sequence asn1Sequence) {
        this.enumeration = asn1Sequence.getObjects();
        this.enumeration.nextElement();
        this.version = V1;
        this.type = ASN1Integer.getInstance(this.enumeration.nextElement());
        this.transNonce = ASN1OctetString.getInstance(this.enumeration.nextElement());
        this.number = ASN1Integer.getInstance(this.enumeration.nextElement());
        this.time = ASN1GeneralizedTime.getInstance(this.enumeration.nextElement());
    }

    public TBSIssue(ASN1Integer type, ASN1OctetString transNonce, ASN1Integer number, ASN1GeneralizedTime time) {
        this.version = V1;
        this.type = type;
        this.transNonce = transNonce;
        this.number = number;
        this.time = time;
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public ASN1Integer getType() {
        return this.type;
    }

    public ASN1OctetString getTransNonce() {
        return this.transNonce;
    }

    public ASN1Integer getNumber() {
        return this.number;
    }

    public ASN1GeneralizedTime getTime() {
        return this.time;
    }

    public ASN1EncodableVector getVector() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.version);
        vector.add((ASN1Encodable)this.type);
        if (this.transNonce != null) {
            vector.add((ASN1Encodable)this.transNonce);
        }
        if (this.number != null) {
            vector.add((ASN1Encodable)this.number);
        }
        vector.add((ASN1Encodable)this.time);
        return vector;
    }
}

