/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.issue;

import com.xdja.pki.asn1.issue.PkixIssueResponse;
import com.xdja.pki.asn1.issue.TBSIssueRequest;
import com.xdja.pki.asn1.issue.TBSIssueResponse;
import com.xdja.pki.gmssl.crypto.sdf.SdfCryptoType;
import com.xdja.pki.issue.BasicPkixIssue;
import com.xdja.pki.issue.TBSIssueResponseStatus;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ocsp.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkixIssueResp
extends BasicPkixIssue {
    private static Logger logger = LoggerFactory.getLogger(PkixIssueResp.class);

    public PkixIssueResp(byte[] response) throws IOException {
        this(new ASN1InputStream(response));
    }

    private PkixIssueResp(ASN1InputStream inputStream) throws IOException {
        this.issue = PkixIssueResponse.getInstance(inputStream.readObject());
    }

    PkixIssueResp(TBSIssueResponse tbsIssueResponse, Signature signature) {
        this.issue = new PkixIssueResponse(tbsIssueResponse, signature.getSignatureAlgorithm(), signature);
    }

    public TBSIssueResponseStatus getStatus() throws Exception {
        TBSIssueResponse tbsIssueResponse = (TBSIssueResponse)this.issue.getTBSIssue();
        return TBSIssueResponseStatus.decode(tbsIssueResponse.getResponseStatus());
    }

    public static boolean verifyTime(TBSIssueResponse respIssue, int time) throws ParseException {
        Long nowTime = System.currentTimeMillis();
        Long getTime = respIssue.getTime().getDate().getTime();
        if (nowTime - getTime >= (long)(1000 * time)) {
            logger.error("now time " + new Date(nowTime).toString());
            logger.error("get time " + new Date(getTime).toString());
            logger.error("verify time error nowTime = " + nowTime + " getTime = " + getTime + " SUB = " + (nowTime - getTime));
            return false;
        }
        return true;
    }

    public static boolean verifyTranNonce(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getTransNonce().equals((Object)respIssue.getTransNonce())) {
            return true;
        }
        logger.error("req transNonce" + reqIssue.getTransNonce().toString());
        logger.error("resp transNonce" + respIssue.getTransNonce().toString());
        return false;
    }

    public static boolean verifyNumber(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getNumber().equals((Object)respIssue.getNumber())) {
            return true;
        }
        logger.error("req Number" + reqIssue.getNumber().toString());
        logger.error("resp Number" + respIssue.getNumber().toString());
        return false;
    }

    public static boolean verifyType(TBSIssueRequest reqIssue, TBSIssueResponse respIssue) {
        if (reqIssue.getType().equals((Object)respIssue.getType())) {
            return true;
        }
        logger.error("req type" + reqIssue.getType().toString());
        logger.error("resp type" + respIssue.getType().toString());
        return false;
    }

    public static boolean verifySign(PkixIssueResp resp, boolean isOCSPRes, List<X509Certificate> ocspSignCerts, List<X509Certificate> ldapSignCerts, boolean isSignByBC, SdfCryptoType sdfCryptoType) throws Exception {
        List<X509Certificate> certificates;
        if (isOCSPRes) {
            logger.debug("\u4f7f\u7528OCSP\u670d\u52a1\u5668\u8bc1\u4e66\u9a8c\u7b7e ");
            certificates = ocspSignCerts;
        } else {
            logger.debug("\u4f7f\u7528LDAP\u670d\u52a1\u5668\u8bc1\u4e66\u9a8c\u7b7e ");
            certificates = ldapSignCerts;
        }
        if (isSignByBC) {
            return resp.verifySignatureByBC(certificates, certificates.get(0).getSigAlgName());
        }
        return resp.verifySignatureBySdf(certificates, sdfCryptoType);
    }
}

