package com.xdja.pki.ldap.sdk.ca;

import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class LDAPUrlUtils {
    private LDAPUrlUtils() {

    }

    //1．	CRLDistributionPoints CA
    public static String getCAARLLdapUrl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return setCRLExtension(host, port, issueDn, crlSegment, "authorityRevocationList;binary");
    }

    //              User
    public static String getUserCRLLdapUrl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return setCRLExtension(host, port, issueDn, crlSegment, "certificateRevocationList;binary");
    }

    //2．	FreshestCRL
    public static String getCertDRLLdapurl(String host, int port, String issueDn, int crlSegment) throws Exception {
        return setCRLExtension(host, port, issueDn, crlSegment, "deltaRevocationList;binary");
    }


    //3．	Authority Information Access
    public static String getCertIssueLdapurl(String host, int port, String issueDn) {

        return setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    //4.	Subject Information Access  CA
    public static String getCASubjectLdapUrl(String host, int port, String subjectDn) {
        return setCertExtension(host, port, subjectDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    // User
    public static String getUsersubjectLdapUrl(String host, int port, String subjectDn) {
        String url = setCertExtension(host, port, subjectDn, "userCertificate;binary");
        return url;
    }

    //1.	Authority Information Access
    public static String getCRLIssueLdapUrl(String host, int port, String issueDn) {
        return setCertExtension(host, port, issueDn, "cACertificate;binary,crossCertificatePair;binary");
    }

    private static String setCRLExtension(String host, int port, String issueDn, int crlSegment, String name) throws Exception {
        String cn = "crl" + crlSegment;
        LdapName ldapName = new LdapName(issueDn);
        Rdn rdn = ldapName.getRdn(ldapName.size() - 1);
        String rdnString = rdn.toString();
        String dn = "cn=" + cn + ",o=" + rdn.getValue() + "CRL" + issueDn.replace(rdnString, "");
        String url = "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        return url;
    }

    private static String setCertExtension(String host, int port, String dn, String name) {
        String url = "ldap://" + host + ":" + port + "/" + dn + "?" + name;
        return url;
    }
}
